package plugins.ylemontag.complex;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Representation of complex-valued sequences
 */
public enum ComplexRepresentation
{
	CARTESIAN("Cartesian", "Cartesian", "a+i*b"       ),
	POLAR    ("Polar"    , "polar"    , "r*exp(i*theta)");
	
	private String _name;
	private String _nameLowCase;
	private String _symbol;
	
	/**
	 * Constructor
	 */
	private ComplexRepresentation(String name, String nameLowCase, String symbol)
	{
		_name = name;
		_nameLowCase = nameLowCase;
		_symbol = symbol;
	}
	
	/**
	 * Return the name of the representation
	 */
	public String getName()
	{
		return _name;
	}
	
	/**
	 * Return the low-case name of the representation 
	 */
	public String getNameLowCase()
	{
		return _nameLowCase;
	}
	
	@Override
	public String toString()
	{
		return _name;
	}
	
	/**
	 * Symbolic representation
	 */
	public String getSymbol()
	{
		return _symbol;
	}
}
