package plugins.tprovoost.scripteditor.scriptblock;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.blocks.util.VarListListener;
import plugins.adufour.vars.gui.model.TypeSelectionModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarTrigger;
import plugins.adufour.vars.util.TypeChangeListener;
import plugins.adufour.vars.util.VarReferencingPolicy;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptVariable;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptingHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.VariableType;
import plugins.tprovoost.scripteditor.scriptinghandlers.js.JSScriptEngine;

public class OldJavascript extends Plugin implements Block, VarListListener, TypeChangeListener
{
    ArrayList<String> languagesInstalled = new ArrayList<String>();
    
    private VarScript inputScript = new VarScript("", "// Click on the button\n// to edit in a frame.\n\noutput0 = input0 * 2");
    
    private VarList inputMap;
    private VarList outputMap;
    
    private int inputIdx  = 0;
    private int outputIdx = 0;
    
    private VarTrigger triggerInput;
    
    private VarTrigger triggerOutput;
    
    private final TypeSelectionModel typeSelector = new TypeSelectionModel(new Class<?>[] {
            Object.class,
            Object[].class,
            Sequence.class,
            ROI[].class,
            Integer.class,
            Double.class,
            int[].class,
            double[].class,
            String.class,
            File.class,
            File[].class });
            
    public OldJavascript()
    {
        ScriptEngineManager factory = new ScriptEngineManager();
        for (ScriptEngineFactory f : factory.getEngineFactories())
        {
            languagesInstalled.add(ScriptEngineHandler.getLanguageName(f));
        }
    }
    
    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public void run()
    {
        ScriptingHandler handler = inputScript.getEditor().getPanelIn().getScriptHandler();
        JSScriptEngine engine = (JSScriptEngine) handler.createNewEngine();
        // String language = inputScript.getEditor().panelIn.getLanguage();
        
        for (Var<?> var : inputMap)
        {
            Object value = var.getValue();
            String name = var.getName();
            if (name.contains("input"))
            {
                // For another language, remove this, or use the right one.
                value = JSScriptBlock.transformInputForScript(value);
                
                // put in the engine the value.
                engine.put(name, value);
            }
        }
        try
        {
            inputScript.evaluate();
        }
        catch (ScriptException e)
        {
            throw new IcyHandledException(e.getMessage());
        }
        
        for (Var output : outputMap)
        {
            Object resObject = engine.get(output.getName());
            output.setValue(JSScriptBlock.transformScriptOutput(resObject));
        }
    }
    
    @Override
    public void declareInput(VarList inputMap)
    {
        if (this.inputMap == null) this.inputMap = inputMap;
        inputMap.addVarListListener(this);
        triggerInput = new VarTrigger("Add Input", new VarTrigger.TriggerListener()
        {
            
            @Override
            public void valueChanged(Var<Integer> source, Integer oldValue, Integer newValue)
            {
                registerVariables();
            }
            
            @Override
            public void referenceChanged(Var<Integer> source, Var<? extends Integer> oldReference, Var<? extends Integer> newReference)
            {
                registerVariables();
            }
            
            @Override
            public void triggered(VarTrigger source)
            {
                String name = "input" + inputIdx;
                VarMutableScript myVariable = new VarMutableScript(name, Object.class);
                myVariable.setDefaultEditorModel(typeSelector);
                myVariable.addTypeChangeListener(new TypeChangeListener()
                {
                    
                    @Override
                    public void typeChanged(Object source, Class<?> oldType, Class<?> newType)
                    {
                        registerVariables();
                    }
                });
                OldJavascript.this.inputMap.addRuntimeVariable("" + myVariable.hashCode(), myVariable);
                registerVariables();
                
            }
        });
        triggerInput.setReferencingPolicy(VarReferencingPolicy.NONE);
        
        triggerOutput = new VarTrigger("Add output", new VarTrigger.TriggerListener()
        {
            
            @Override
            public void valueChanged(Var<Integer> source, Integer oldValue, Integer newValue)
            {
                registerVariables();
            }
            
            @Override
            public void referenceChanged(Var<Integer> source, Var<? extends Integer> oldReference, Var<? extends Integer> newReference)
            {
                registerVariables();
            }
            
            @Override
            public void triggered(VarTrigger source)
            {
                String name = "output" + outputIdx;
                VarMutableScript myVariable = new VarMutableScript(name, Object.class);
                myVariable.setDefaultEditorModel(typeSelector);
                myVariable.addTypeChangeListener(new TypeChangeListener()
                {
                    
                    @Override
                    public void typeChanged(Object source, Class<?> oldType, Class<?> newType)
                    {
                        registerVariables();
                    }
                });
                outputMap.addRuntimeVariable("" + myVariable.hashCode(), myVariable);
                registerVariables();
            }
        });
        triggerOutput.setReferencingPolicy(VarReferencingPolicy.NONE);
        
        inputScript.setReferencingPolicy(VarReferencingPolicy.NONE);
        
        inputMap.add("Script", inputScript);
        inputMap.add("Add Input", triggerInput);
        inputMap.add("Add output", triggerOutput);
        
        String name = "input" + inputIdx;
        VarMutableScript myVariable = new VarMutableScript(name, Object.class);
        myVariable.setDefaultEditorModel(typeSelector);
        myVariable.addTypeChangeListener(this);
        inputMap.add(name, myVariable);
    }
    
    @Override
    public void declareOutput(final VarList outputMap)
    {
        this.outputMap = outputMap;
        outputMap.addVarListListener(this);
        String name = "output" + outputIdx;
        VarMutableScript myVariable = new VarMutableScript(name, Object.class);
        myVariable.setDefaultEditorModel(typeSelector);
        myVariable.addTypeChangeListener(this);
        outputMap.add(name, myVariable);
        registerVariables();
    }
    
    @Override
    public void typeChanged(Object source, Class<?> oldType, Class<?> newType)
    {
        registerVariables();
    }
    
    private void registerVariables()
    {
        final ScriptingHandler handlerIn = inputScript.getEditor().getPanelIn().getScriptHandler();
        final ScriptingHandler handlerOut = inputScript.getEditor().getPanelOut().getScriptHandler();
        
        HashMap<String, ScriptVariable> variablesInt = handlerIn.getExternalVariables();
        HashMap<String, ScriptVariable> variablesExt = handlerOut.getExternalVariables();
        
        variablesInt.clear();
        variablesExt.clear();
        if (inputMap != null) for (Var<?> v : inputMap)
        {
            if (v instanceof VarMutableScript || inputMap.isRuntimeVariable(v))
            {
                variablesInt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
                variablesExt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
            }
        }
        if (outputMap != null) for (Var<?> v : outputMap)
        {
            if (v instanceof VarMutableScript || outputMap.isRuntimeVariable(v))
            {
                variablesInt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
                variablesExt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
            }
        }
        ThreadUtil.invokeLater(new Runnable()
        {
            
            @Override
            public void run()
            {
                handlerIn.interpret(false);
                handlerOut.interpret(false);
            }
        });
    }
    
    @Override
    public void variableAdded(VarList list, Var<?> variable)
    {
        if (list == inputMap && variable != triggerInput && variable != inputScript && variable != triggerOutput) inputIdx++;
        else if (list == outputMap) outputIdx++;
        
        if (list.isRuntimeVariable(variable) && variable instanceof VarMutable)
        {
            VarMutable mutable = (VarMutable) variable;
            Class<?> type = mutable.getType();
            mutable.setDefaultEditorModel(typeSelector);
            mutable.addTypeChangeListener(this);
            mutable.setType(type);
        }
    }
    
    @Override
    public void variableRemoved(VarList list, Var<?> variable)
    {
        if (list.isRuntimeVariable(variable) && variable instanceof VarMutable) ((VarMutable) variable).removeTypeChangeListener(this);
		registerVariables();
	}
}
