package plugins.ylemontag.sequencecomparator.comparators;

/**
 * 
 * @author Yoann Le Montagner
 *
 */
public class GlobalLInf extends PixelSeparableGlobalComparator
{	
	/**
	 * Constructor
	 */
	public GlobalLInf(String distanceName)
	{
		super(distanceName);
	}
	
	@Override
	protected double aggregateInsideXY(double accu, double refPixel, double seqPixel)
	{
		return Math.max(accu, Math.abs(seqPixel - refPixel));
	}

	@Override
	protected double aggregateOutsideXY(double accu, double errorOverPlane)
	{
		return Math.max(accu, errorOverPlane);
	}
}
