/*
 * Copyright 2010, 2011 Institut Pasteur.
 * 
 * This file is part of ICY.
 * 
 * ICY is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * ICY is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ICY. If not, see <http://www.gnu.org/licenses/>.
 */
package plugins.fab.trackmanager.processors;

import icy.canvas.IcyCanvas;
import icy.gui.component.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.main.Icy;
import icy.painter.Painter;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;

import com.imaging100x.tracker.TrackerControl;

import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

/**
 * @author Fabrice de Chaumont
 * 
 */
public class TrackProcessorDisplayTrackNumber extends PluginTrackManagerProcessor implements ActionListener , Painter, SequenceListener, ViewerListener
{

    public TrackProcessorDisplayTrackNumber()
    {

    	setName("Display Track Number Track Processor");
        panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));

        panel.add( GuiUtil.createLineBoxPanel( Box.createVerticalStrut( 5 ) ) );
        		

        panel.add( GuiUtil.createLineBoxPanel( Box.createVerticalStrut( 5 ) ) );

    }

    @Override
    public void Compute()
    {

        if (isEnabled())
        {        	
			try
			{
				trackPool.getDisplaySequence().addPainter( this );
			}
			catch ( NullPointerException e) {
				// sequence or trackpool is null
			}

        
        }else
        {
			try
			{
				trackPool.getDisplaySequence().removePainter( this );
			}
			catch ( NullPointerException e) {
				// sequence or trackpool is null
			}
        }

    }

    public void actionPerformed(ActionEvent e)
    {
        //randomColorComputed = false;
        trackPool.fireTrackEditorProcessorChange();
    }

    @Override
    public void Close()
    {
    }

	@Override
	public void displaySequenceChanged() {

		for ( Sequence sequence: Icy.getMainInterface().getSequencesContaining( this ) )
		{
			sequence.removePainter( this );
		}
		
		Sequence displaySequence = trackPool.getDisplaySequence();
		if ( displaySequence != null )
		{
			trackPool.getDisplaySequence().addPainter( this );
		}
		
	}

	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {

		if ( g == null ) return;
		
		for (TrackGroup group : trackPool.getTrackGroupList())
		{
			for (TrackSegment trackSegment : group.getTrackSegmentList())
			{
				//if ( trackSegment.isAllDetectionEnabled() )
				//if ( trackSegment.get)
				
				Detection firstDetection = null;
				
				ArrayList<Detection> detectionList = trackSegment.getDetectionList();
				for ( Detection detection : detectionList )
				{
					if ( detection.isEnabled() )
					{
						firstDetection = detection;
						break;
					}
				}
				
				if ( firstDetection == null ) continue;
				
				
				// display number
				{
					int index = trackPool.getTrackIndex( trackSegment );
										
					g.setColor( firstDetection.getColor() );
					
					g.drawString( ""+index, (float)firstDetection.getX(), (float)firstDetection.getY() );

				}


			}

		}
		
	}

	@Override
	public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
	}

	@Override
	public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
	}

	@Override
	public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
	}

	@Override
	public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
	}

	@Override
	public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
	}

	@Override
	public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
	}

	@Override
	public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
	}

	
	
	@Override
	public void sequenceChanged(SequenceEvent sequenceEvent) {

		for ( Viewer viewer : Icy.getMainInterface().getViewers() )
		{
			viewer.removeListener( this );			
		}
		if( trackPool.getDisplaySequence() != null )
		{
			trackPool.getDisplaySequence().getViewers().get( 0 ).addListener( this );			
		}
		
	}

	@Override
	public void sequenceClosed(Sequence sequence) {
		
	}

	@Override
	public void viewerChanged(ViewerEvent event) {
		
	}

	@Override
	public void viewerClosed(Viewer viewer) {

		
	}
}
