/*
 * Decompiled with CFR 0.152.
 */
package mitiv.invpb;

import mitiv.array.ArrayFactory;
import mitiv.array.ShapedArray;
import mitiv.conv.WeightedConvolutionCost;
import mitiv.invpb.SmoothInverseProblem;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.OptimTask;

public class Deconvolution
extends SmoothInverseProblem {
    protected boolean updatePending = true;
    protected Vector x = null;
    protected ShapedArray object = null;

    protected void forceRestart() {
        this.updatePending = true;
    }

    public OptimTask start() {
        return this.start(false);
    }

    public OptimTask start(boolean reset) {
        if (this.updatePending) {
            this.update();
        }
        return super.start(this.x, reset);
    }

    public OptimTask iterate() {
        if (this.updatePending) {
            return this.start();
        }
        return super.iterate(this.x);
    }

    protected static void error(String reason) {
        throw new IllegalArgumentException(reason);
    }

    public void setInitialSolution(ShapedArray arr) {
        if (this.object != arr) {
            this.object = arr;
            this.forceRestart();
            this.resetIteration();
        }
    }

    @Override
    public ShapedVector getBestSolution() {
        return (ShapedVector)super.getBestSolution();
    }

    protected void update() {
        ShapedVectorSpace objectSpace = (ShapedVectorSpace)super.getLikelihood().getInputSpace();
        int type = objectSpace.getType();
        boolean wrap = this.object.getType() != type || !this.object.isFlat();
        this.x = objectSpace.create(this.object, false);
        if (wrap) {
            this.object = type == 4 ? ArrayFactory.wrap(((FloatShapedVector)this.x).getData(), objectSpace.getShape()) : ArrayFactory.wrap(((DoubleShapedVector)this.x).getData(), objectSpace.getShape());
        }
        this.updatePending = false;
    }

    public ShapedArray getSolution() {
        return this.object;
    }

    public ShapedArray getModel() {
        return ((WeightedConvolutionCost)this.getLikelihood()).getModel(this.getBestSolution().asShapedArray()).asShapedArray();
    }
}

