/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.util;

import icy.common.listener.weak.WeakListener;
import icy.gui.util.CustomPopupFactory;
import icy.image.ImageUtil;
import icy.preferences.GeneralPreferences;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.ClassUtil;
import icy.util.ReflectionUtil;
import icy.util.StringUtil;
import ij.util.Java2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InternalFrameUI;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.LightAquaColorScheme;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.api.fonts.SubstanceFontUtilities;
import org.pushingpixels.substance.api.skin.SkinChangeListener;
import org.pushingpixels.substance.api.skin.SkinInfo;
import org.pushingpixels.substance.internal.ui.SubstanceInternalFrameUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;

public class LookAndFeelUtil {
    static int defaultFontSize;
    static Map<String, SkinInfo> map;
    private static ArrayList<SkinInfo> skins;
    static int currentFontSize;

    public static void init() {
        try {
            ReflectionUtil.getField(Java2.class, "lookAndFeelSet", true).set(null, true);
        }
        catch (Throwable t1) {
            try {
                Java2.setSystemLookAndFeel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        SystemUtil.setProperty("insubstantial.checkEDT", "false");
        SystemUtil.setProperty("insubstantial.logEDT", "true");
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        map = SubstanceLookAndFeel.getAllSkins();
        skins = new ArrayList<SkinInfo>(map.values());
        UIManager.LookAndFeelInfo[] lafInfos = new UIManager.LookAndFeelInfo[skins.size()];
        for (int i = 0; i < skins.size(); ++i) {
            SkinInfo skin = skins.get(i);
            String className = skin.getClassName();
            String simpleName = ClassUtil.getSimpleClassName(className);
            int len = simpleName.length();
            String lafClassName = ClassUtil.getPackageName(className) + ".Substance" + simpleName.substring(0, len - 4) + "LookAndFeel";
            lafInfos[i] = new UIManager.LookAndFeelInfo(skin.getDisplayName(), lafClassName);
        }
        UIManager.setInstalledLookAndFeels(lafInfos);
        LookAndFeelUtil.setSkin(GeneralPreferences.getGuiSkin());
        FontPolicy fontPolicy = SubstanceFontUtilities.getDefaultFontPolicy();
        FontSet fontSet = fontPolicy.getFontSet("Substance", null);
        currentFontSize = defaultFontSize = fontSet.getMessageFont().getSize();
        LookAndFeelUtil.setFontSize(GeneralPreferences.getGuiFontSize());
        PopupFactory.setSharedInstance(new CustomPopupFactory());
    }

    public static void addSkinChangeListener(SkinChangeListener listener) {
        SubstanceLookAndFeel.registerSkinChangeListener((SkinChangeListener)listener);
    }

    public static void removeSkinChangeListener(SkinChangeListener listener) {
        SubstanceLookAndFeel.unregisterSkinChangeListener((SkinChangeListener)listener);
    }

    public static SubstanceSkin getCurrentSkin() {
        return SubstanceLookAndFeel.getCurrentSkin();
    }

    public static String getCurrentSkinName() {
        SubstanceSkin skin = LookAndFeelUtil.getCurrentSkin();
        if (skin != null) {
            return skin.getDisplayName();
        }
        return null;
    }

    public static JCommandPopupMenu getLookAndFeelMenu() {
        JCommandPopupMenu result = new JCommandPopupMenu();
        CommandToggleButtonGroup buttonGroup = new CommandToggleButtonGroup();
        String currentSkinName = LookAndFeelUtil.getCurrentSkinName();
        for (SkinInfo skin : skins) {
            final String skinName = skin.getDisplayName();
            JCommandToggleMenuButton button = new JCommandToggleMenuButton(skinName, null);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LookAndFeelUtil.setSkin(skinName);
                    GeneralPreferences.setGuiSkin(skinName);
                }
            });
            result.addMenuButton(button);
            button.getUI().installUI((JComponent)button);
            buttonGroup.add((JCommandToggleButton)button);
            buttonGroup.setSelected((JCommandToggleButton)button, button.getText().equals(currentSkinName));
        }
        return result;
    }

    public static int getDefaultFontSize() {
        return defaultFontSize;
    }

    public static String getDefaultSkin() {
        return skins.get(4).getDisplayName();
    }

    public static int getFontSize() {
        return currentFontSize;
    }

    public static void setFontSize(final int size) {
        if (size != currentFontSize) {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    float scaleFactor = (float)size / (float)defaultFontSize;
                    try {
                        SubstanceLookAndFeel.setFontPolicy((FontPolicy)SubstanceFontUtilities.getScaledFontPolicy((float)scaleFactor));
                        currentFontSize = size;
                    }
                    catch (Exception e) {
                        System.err.println("LookAndFeelUtil.setFontSize(...) error :");
                        IcyExceptionHandler.showErrorMessage(e, false);
                    }
                }
            });
        }
    }

    public static void setSkin(final String skinName) {
        if (!StringUtil.equals(skinName, LookAndFeelUtil.getCurrentSkinName())) {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        SubstanceLookAndFeel.setSkin((String)map.get(skinName).getClassName());
                    }
                    catch (Exception e) {
                        System.err.println("LookAndFeelUtil.setSkin(...) error :");
                        IcyExceptionHandler.showErrorMessage(e, false);
                    }
                }
            });
        }
    }

    public static Image getForegroundImageFromAlphaImage(Component c, Image alphaImage) {
        return LookAndFeelUtil.paintForegroundImageFromAlphaImage(c, alphaImage, null);
    }

    public static Image getBackgroundImageFromAlphaImage(Component c, Image alphaImage) {
        return LookAndFeelUtil.paintBackgroundImageFromAlphaImage(c, alphaImage, null);
    }

    public static Image paintForegroundImageFromAlphaImage(Component c, Image alphaImage, Image out) {
        return ImageUtil.paintColorImageFromAlphaImage(alphaImage, out, LookAndFeelUtil.getForeground(c));
    }

    public static Image paintBackgroundImageFromAlphaImage(Component c, Image alphaImage, Image out) {
        return ImageUtil.paintColorImageFromAlphaImage(alphaImage, out, LookAndFeelUtil.getBackground(c));
    }

    public static SubstanceColorScheme getActiveColorScheme(DecorationAreaType d) {
        return LookAndFeelUtil.getCurrentSkin().getActiveColorScheme(d);
    }

    @Deprecated
    public static SubstanceColorScheme getActiveColorSheme(DecorationAreaType d) {
        return LookAndFeelUtil.getActiveColorScheme(d);
    }

    public static SubstanceColorScheme getBackgroundColorScheme(DecorationAreaType d) {
        SubstanceSkin skin = LookAndFeelUtil.getCurrentSkin();
        if (skin != null) {
            return skin.getBackgroundColorScheme(d);
        }
        return new LightAquaColorScheme();
    }

    public static SubstanceColorScheme getDisabledColorScheme(DecorationAreaType d) {
        SubstanceSkin skin = LookAndFeelUtil.getCurrentSkin();
        if (skin != null) {
            return skin.getDisabledColorScheme(d);
        }
        return new LightAquaColorScheme();
    }

    public static SubstanceColorScheme getEnabledColorScheme(DecorationAreaType d) {
        SubstanceSkin skin = LookAndFeelUtil.getCurrentSkin();
        if (skin != null) {
            return skin.getEnabledColorScheme(d);
        }
        return new LightAquaColorScheme();
    }

    public static SubstanceSkin getSkin() {
        return SubstanceLookAndFeel.getCurrentSkin();
    }

    public static SubstanceSkin getSkin(Component c) {
        return SubstanceLookAndFeel.getCurrentSkin((Component)c);
    }

    public static DecorationAreaType getDecoration(Component c) {
        return SubstanceLookAndFeel.getDecorationType((Component)c);
    }

    public static SubstanceColorScheme getColorScheme(Component c, ComponentState state) {
        return LookAndFeelUtil.getSkin().getColorScheme(c, state);
    }

    public static SubstanceColorScheme getColorScheme(Component c, ColorSchemeAssociationKind kind, ComponentState state) {
        return LookAndFeelUtil.getSkin().getColorScheme(c, kind, state);
    }

    public static SubstanceColorScheme getActiveColorScheme(Component c) {
        SubstanceSkin skin = LookAndFeelUtil.getSkin(c);
        DecorationAreaType decoration = LookAndFeelUtil.getDecoration(c);
        if (skin != null && decoration != null) {
            return skin.getActiveColorScheme(decoration);
        }
        return null;
    }

    public static SubstanceColorScheme getActiveColorScheme(Component c, ComponentState state) {
        return SubstanceColorSchemeUtilities.getActiveColorScheme((Component)c, (ComponentState)state);
    }

    @Deprecated
    public static SubstanceColorScheme getActiveColorSheme(Component c) {
        return LookAndFeelUtil.getActiveColorScheme(c);
    }

    @Deprecated
    public static SubstanceColorScheme getActiveColorSheme(Component c, ComponentState state) {
        return LookAndFeelUtil.getActiveColorScheme(c, state);
    }

    public static SubstanceColorScheme getBackgroundColorScheme(Component c) {
        SubstanceSkin skin = LookAndFeelUtil.getSkin(c);
        DecorationAreaType decoration = LookAndFeelUtil.getDecoration(c);
        if (skin != null && decoration != null) {
            return skin.getBackgroundColorScheme(decoration);
        }
        return null;
    }

    public static SubstanceColorScheme getDisabledColorScheme(Component c) {
        SubstanceSkin skin = LookAndFeelUtil.getSkin(c);
        DecorationAreaType decoration = LookAndFeelUtil.getDecoration(c);
        if (skin != null && decoration != null) {
            return skin.getDisabledColorScheme(decoration);
        }
        return null;
    }

    public static SubstanceColorScheme getEnabledColorScheme(Component c) {
        SubstanceSkin skin = LookAndFeelUtil.getSkin(c);
        DecorationAreaType decoration = LookAndFeelUtil.getDecoration(c);
        if (skin != null && decoration != null) {
            return skin.getEnabledColorScheme(decoration);
        }
        return null;
    }

    public static Color getForeground(Component c) {
        SubstanceColorScheme colorScheme = c == null ? LookAndFeelUtil.getEnabledColorScheme(DecorationAreaType.GENERAL) : (c.isEnabled() ? LookAndFeelUtil.getEnabledColorScheme(c) : LookAndFeelUtil.getDisabledColorScheme(c));
        if (colorScheme == null) {
            LookAndFeelUtil.getEnabledColorScheme(DecorationAreaType.GENERAL);
        }
        if (colorScheme != null) {
            return new ColorUIResource(colorScheme.getForegroundColor());
        }
        if (c != null) {
            return c.getForeground();
        }
        return Color.white;
    }

    public static Color getSelectedForeground(Component c) {
        SubstanceColorScheme colorScheme = c == null ? LookAndFeelUtil.getEnabledColorScheme(DecorationAreaType.GENERAL) : (c.isEnabled() ? LookAndFeelUtil.getEnabledColorScheme(c) : LookAndFeelUtil.getDisabledColorScheme(c));
        if (colorScheme == null) {
            LookAndFeelUtil.getEnabledColorScheme(DecorationAreaType.GENERAL);
        }
        if (colorScheme != null) {
            return new ColorUIResource(colorScheme.getSelectionForegroundColor());
        }
        if (c != null) {
            return c.getForeground();
        }
        return Color.gray;
    }

    public static Color getBackground(Component c) {
        SubstanceColorScheme colorScheme = c == null ? LookAndFeelUtil.getEnabledColorScheme(DecorationAreaType.GENERAL) : (c.isEnabled() ? LookAndFeelUtil.getEnabledColorScheme(c) : LookAndFeelUtil.getDisabledColorScheme(c));
        if (colorScheme == null) {
            LookAndFeelUtil.getEnabledColorScheme(DecorationAreaType.GENERAL);
        }
        if (colorScheme != null) {
            return new ColorUIResource(colorScheme.getBackgroundFillColor());
        }
        if (c != null) {
            return c.getBackground();
        }
        return Color.lightGray;
    }

    public static Color getSelectedBackground(Component c) {
        SubstanceColorScheme colorScheme = c == null ? LookAndFeelUtil.getEnabledColorScheme(DecorationAreaType.GENERAL) : (c.isEnabled() ? LookAndFeelUtil.getEnabledColorScheme(c) : LookAndFeelUtil.getDisabledColorScheme(c));
        if (colorScheme == null) {
            LookAndFeelUtil.getEnabledColorScheme(DecorationAreaType.GENERAL);
        }
        if (colorScheme != null) {
            return new ColorUIResource(colorScheme.getSelectionBackgroundColor());
        }
        if (c != null) {
            return c.getBackground();
        }
        return Color.darkGray;
    }

    public static SubstanceTitlePane getTitlePane(Window window) {
        return (SubstanceTitlePane)SubstanceLookAndFeel.getTitlePaneComponent((Window)window);
    }

    public static SubstanceInternalFrameTitlePane getTitlePane(JInternalFrame frame) {
        InternalFrameUI ui = frame.getUI();
        if (ui instanceof SubstanceInternalFrameUI) {
            return ((SubstanceInternalFrameUI)ui).getTitlePane();
        }
        return null;
    }

    public static void setTitlePane(JInternalFrame frame, SubstanceInternalFrameTitlePane titlePane) {
        InternalFrameUI ui = frame.getUI();
        if (ui instanceof SubstanceInternalFrameUI) {
            ((SubstanceInternalFrameUI)ui).setNorthPane((JComponent)titlePane);
        }
    }

    public static class WeakSkinChangeListener
    extends WeakListener<SkinChangeListener>
    implements SkinChangeListener {
        public WeakSkinChangeListener(SkinChangeListener listener) {
            super(listener);
        }

        @Override
        public void removeListener(Object source) {
            LookAndFeelUtil.removeSkinChangeListener(this);
        }

        public void skinChanged() {
            SkinChangeListener listener = (SkinChangeListener)this.getListener();
            if (listener != null) {
                listener.skinChanged();
            }
        }
    }
}

