/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.measure;

import icy.math.UnitUtil;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.util.StringUtil;
import plugins.kernel.roi.descriptor.measure.ROIInteriorDescriptor;

public class ROIAreaDescriptor
extends ROIDescriptor {
    public static final String ID = "Area";

    public ROIAreaDescriptor() {
        super(ID, ID, Double.class);
    }

    @Override
    public String getDescription() {
        return ID;
    }

    @Override
    public String getUnit(Sequence sequence) {
        if (sequence != null) {
            return sequence.getBestPixelSizeUnit(2, 2).toString() + "m2";
        }
        return UnitUtil.UnitPrefix.MICRO.toString() + "m2";
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        SequenceEvent.SequenceEventSourceType sourceType = change.getSourceType();
        if (sourceType == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
            return true;
        }
        if (sourceType == SequenceEvent.SequenceEventSourceType.SEQUENCE_META) {
            String metaName = (String)change.getSource();
            return StringUtil.isEmpty(metaName) || StringUtil.equals(metaName, "pixelSizeX") || StringUtil.equals(metaName, "pixelSizeY") || StringUtil.equals(metaName, "pixelSizeZ");
        }
        return false;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        return ROIAreaDescriptor.computeArea(roi, sequence);
    }

    public static double computeArea(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        return ROIAreaDescriptor.computeArea(ROIInteriorDescriptor.computeInterior(roi), roi, sequence);
    }

    public static double computeArea(double interiorPoints, ROI roi, Sequence sequence) throws UnsupportedOperationException {
        try {
            if (!(roi instanceof ROI2D)) {
                throw new UnsupportedOperationException();
            }
            return ROIInteriorDescriptor.computeInterior(interiorPoints, roi, sequence, 2);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Can't process Area calculation for ROI: '" + roi.getName() + "'");
        }
    }
}

