/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.image.projection;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.math.ArrayMath;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import icy.util.OMEUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import ome.xml.meta.MetadataRetrieve;
import org.bioimageanalysis.icy.image.projection.ProjectionAxis;
import org.bioimageanalysis.icy.image.projection.ProjectionOperationType;
import org.bioimageanalysis.icy.image.projection.util.MessageProgressListener;

public class ProjectionCalculator
implements Callable<Sequence> {
    private Sequence seq;
    private List<ROI> rois;
    private ProjectionAxis axis;
    private ProjectionOperationType op;
    private List<MessageProgressListener> progressListeners = new ArrayList<MessageProgressListener>();
    private boolean computed = false;
    private Sequence result;

    private ProjectionCalculator() {
    }

    public void addProgressListener(MessageProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(MessageProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    @Override
    public Sequence call() throws Exception {
        try {
            if (!this.computed) {
                this.createResultSequence();
                this.result.beginUpdate();
                this.computeProjection();
                this.result.endUpdate();
                this.computed = true;
            }
            Sequence sequence = this.getResultSequence();
            return sequence;
        }
        finally {
            this.notifyProgress(1.0, "Projection finished");
        }
    }

    private void createResultSequence() throws InterruptedException {
        this.result = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)this.seq.getOMEXMLMetadata()), (Object)((Object)this.op) + " " + (Object)((Object)this.axis) + "-projection of " + this.seq.getName());
        int width = this.axis == ProjectionAxis.X ? 1 : this.seq.getSizeX();
        int height = this.axis == ProjectionAxis.Y ? 1 : this.seq.getSizeY();
        int depth = this.axis == ProjectionAxis.Z ? 1 : this.seq.getSizeZ();
        int frames = this.axis == ProjectionAxis.T ? 1 : this.seq.getSizeT();
        int channels = this.axis == ProjectionAxis.C ? 1 : this.seq.getSizeC();
        DataType dataType = this.seq.getDataType_();
        for (int t = 0; t < frames; ++t) {
            VolumetricImage vol = new VolumetricImage();
            for (int z = 0; z < depth; ++z) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                vol.setImage(z, new IcyBufferedImage(width, height, channels, dataType));
            }
            this.result.addVolumetricImage(t, vol);
            this.notifyProgress(Math.max(0.01, (double)t * (0.1 / (double)frames)), "Creating result sequence t=" + t);
        }
        if (this.axis != ProjectionAxis.C) {
            for (int c = 0; c < this.seq.getSizeC(); ++c) {
                this.result.getColorModel().setColorMap(c, this.seq.getColorMap(c), true);
            }
        }
        this.notifyProgress(0.01, "Result sequence instatiated");
    }

    private void computeProjection() throws InterruptedException, ExecutionException {
        switch (this.axis) {
            case X: {
                this.startProjectionOnPlane();
                break;
            }
            case Y: {
                this.startProjectionOnPlane();
                break;
            }
            case Z: {
                this.startZProjection();
                break;
            }
            case T: {
                this.startTProjection();
                break;
            }
            case C: {
                this.startProjectionOnPlane();
            }
        }
        this.notifyProgress(1.0, (Object)((Object)this.axis) + "-projection done");
    }

    private void startProjectionOnPlane() throws InterruptedException, ExecutionException {
        int z;
        int tOff;
        int t;
        int frames = this.seq.getSizeT();
        int depth = this.seq.getSizeZ();
        int channels = this.seq.getSizeC();
        int height = this.seq.getSizeY();
        int width = this.seq.getSizeX();
        IcyBufferedImage[] inputPlanes = new IcyBufferedImage[frames * depth];
        IcyBufferedImage[] outputPlanes = new IcyBufferedImage[frames * depth];
        for (t = 0; t < frames; ++t) {
            tOff = t * depth;
            for (z = 0; z < depth; ++z) {
                inputPlanes[tOff + z] = this.seq.getImage(t, z);
                outputPlanes[tOff + z] = this.result.getImage(t, z);
            }
        }
        ForkJoinPool generalTaskPool = (ForkJoinPool)Executors.newWorkStealingPool(Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        ArrayList<Future> futures = new ArrayList<Future>(frames * depth);
        for (t = 0; t < frames; ++t) {
            tOff = t * depth;
            for (z = 0; z < depth; ++z) {
                Callable<IcyBufferedImage> task;
                switch (this.axis) {
                    case X: {
                        task = this.getImageXProjectionTask(inputPlanes[tOff + z], outputPlanes[tOff + z], t, z, channels, height, width);
                        break;
                    }
                    case Y: {
                        task = this.getImageYProjectionTask(inputPlanes[tOff + z], outputPlanes[tOff + z], t, z, channels, height, width);
                        break;
                    }
                    case C: {
                        task = this.getImageCProjectionTask(inputPlanes[tOff + z], outputPlanes[tOff + z], t, z, channels, height, width);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong axis parameter");
                    }
                }
                futures.add(generalTaskPool.submit(task));
            }
        }
        generalTaskPool.shutdown();
        int pos = 0;
        for (t = 0; t < frames; ++t) {
            for (z = 0; z < depth; ++z) {
                try {
                    ((Future)futures.get(pos++)).get();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    generalTaskPool.shutdownNow();
                    throw e;
                }
            }
            this.notifyProgress(0.01 + 0.99 * ((double)t / (double)frames), (Object)((Object)this.axis) + "-projection: Processed t=" + t);
        }
    }

    private Callable<IcyBufferedImage> getImageXProjectionTask(IcyBufferedImage inputPlane, IcyBufferedImage outputPlane, int t, int z, int channels, int height, int width) {
        return () -> {
            double[] elements = new double[width];
            IcyBufferedImageCursor inputCursor = new IcyBufferedImageCursor(inputPlane);
            IcyBufferedImageCursor outputCursor = new IcyBufferedImageCursor(outputPlane);
            for (int channel = 0; channel < channels; ++channel) {
                for (int line = 0; line < height; ++line) {
                    int elementsCount = 0;
                    block2: for (int column = 0; column < width; ++column) {
                        if (this.rois.isEmpty()) {
                            elements[elementsCount++] = inputCursor.get(column, line, channel);
                            continue;
                        }
                        for (ROI roi : this.rois) {
                            if (!roi.contains((double)column, (double)line, (double)z, (double)t, (double)channel)) continue;
                            elements[elementsCount++] = inputCursor.get(column, line, channel);
                            continue block2;
                        }
                    }
                    if (elementsCount == 0) {
                        outputCursor.setSafe(0, line, channel, 0.0);
                        continue;
                    }
                    outputCursor.setSafe(0, line, channel, this.computeResVal(Arrays.copyOf(elements, elementsCount)));
                }
            }
            outputCursor.commitChanges();
            return outputPlane;
        };
    }

    private Callable<IcyBufferedImage> getImageYProjectionTask(IcyBufferedImage inputPlane, IcyBufferedImage outputPlane, int t, int z, int channels, int height, int width) {
        return () -> {
            double[] elements = new double[height];
            IcyBufferedImageCursor inputCursor = new IcyBufferedImageCursor(inputPlane);
            IcyBufferedImageCursor outputCursor = new IcyBufferedImageCursor(outputPlane);
            for (int channel = 0; channel < channels; ++channel) {
                for (int column = 0; column < width; ++column) {
                    int elementsCount = 0;
                    block2: for (int line = 0; line < height; ++line) {
                        if (this.rois.isEmpty()) {
                            elements[elementsCount++] = inputCursor.get(column, line, channel);
                            continue;
                        }
                        for (ROI roi : this.rois) {
                            if (!roi.contains((double)column, (double)line, (double)z, (double)t, (double)channel)) continue;
                            elements[elementsCount++] = inputCursor.get(column, line, channel);
                            continue block2;
                        }
                    }
                    if (elementsCount == 0) {
                        outputCursor.setSafe(column, 0, channel, 0.0);
                        continue;
                    }
                    outputCursor.setSafe(column, 0, channel, this.computeResVal(Arrays.copyOf(elements, elementsCount)));
                }
            }
            outputCursor.commitChanges();
            return outputPlane;
        };
    }

    private Callable<IcyBufferedImage> getImageCProjectionTask(IcyBufferedImage inputPlane, IcyBufferedImage outputPlane, int t, int z, int channels, int height, int width) {
        return () -> {
            int channel;
            double[] elements = new double[height];
            IcyBufferedImageCursor[] inputCursors = new IcyBufferedImageCursor[channels];
            IcyBufferedImageCursor outputCursor = new IcyBufferedImageCursor(outputPlane);
            for (channel = 0; channel < channels; ++channel) {
                inputCursors[channel] = new IcyBufferedImageCursor(inputPlane);
            }
            for (int column = 0; column < width; ++column) {
                for (int line = 0; line < height; ++line) {
                    int elementsCount = 0;
                    block3: for (channel = 0; channel < channels; ++channel) {
                        if (this.rois.isEmpty()) {
                            elements[elementsCount++] = inputCursors[channel].get(column, line, channel);
                            continue;
                        }
                        for (ROI roi : this.rois) {
                            if (!roi.contains((double)column, (double)line, (double)z, (double)t, (double)channel)) continue;
                            elements[elementsCount++] = inputCursors[channel].get(column, line, channel);
                            continue block3;
                        }
                    }
                    if (elementsCount == 0) {
                        outputCursor.setSafe(column, line, 0, 0.0);
                        continue;
                    }
                    outputCursor.setSafe(column, line, 0, this.computeResVal(Arrays.copyOf(elements, elementsCount)));
                }
            }
            outputCursor.commitChanges();
            return outputPlane;
        };
    }

    private void startZProjection() throws InterruptedException, ExecutionException {
        int c;
        int t;
        int width = this.seq.getSizeX();
        int height = this.seq.getSizeY();
        int depth = this.seq.getSizeZ();
        int frames = this.seq.getSizeT();
        int channels = this.seq.getSizeC();
        ForkJoinPool generalTaskPool = (ForkJoinPool)Executors.newWorkStealingPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
        ForkJoinPool volumeTaskPool = (ForkJoinPool)Executors.newWorkStealingPool(Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        ArrayList<Future> futures = new ArrayList<Future>(frames * depth);
        for (t = 0; t < frames; ++t) {
            VolumetricImage inputVolume = this.seq.getVolumetricImage(t);
            VolumetricImage resultVolume = this.result.getVolumetricImage(t);
            for (c = 0; c < channels; ++c) {
                futures.add(generalTaskPool.submit(this.getImageZProjectionTask(t, c, inputVolume, resultVolume, channels, height, width, depth, volumeTaskPool)));
            }
        }
        generalTaskPool.shutdown();
        try {
            int pos = 0;
            for (t = 0; t < frames; ++t) {
                for (c = 0; c < channels; ++c) {
                    ((Future)futures.get(pos++)).get();
                }
                this.notifyProgress(0.01 + 0.99 * ((double)t / (double)frames), (Object)((Object)this.axis) + "-projection: Processed t=" + t);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            generalTaskPool.shutdownNow();
            throw e;
        }
        finally {
            volumeTaskPool.shutdown();
        }
    }

    private Callable<VolumetricImage> getImageZProjectionTask(int t, int c, VolumetricImage inputVolume, VolumetricImage resultVolume, int channels, int height, int width, int depth, ForkJoinPool volumeTaskPool) {
        return () -> {
            IcyBufferedImageCursor[] inputCursors = new IcyBufferedImageCursor[depth];
            IcyBufferedImageCursor outputCursor = new IcyBufferedImageCursor(resultVolume.getImage(0));
            for (int slice = 0; slice < depth; ++slice) {
                inputCursors[slice] = new IcyBufferedImageCursor(inputVolume.getImage(slice));
            }
            ArrayList<Future> futureLines = new ArrayList<Future>(width);
            int line = 0;
            while (line < height) {
                int y = line++;
                futureLines.add(volumeTaskPool.submit(() -> {
                    double[] lineElements = new double[width];
                    double[] elements = new double[depth];
                    for (int x = 0; x < width; ++x) {
                        int elemCount = 0;
                        block1: for (int z = 0; z < depth; ++z) {
                            if (this.rois.isEmpty()) {
                                elements[elemCount++] = inputCursors[z].get(x, y, c);
                                continue;
                            }
                            for (ROI roi : this.rois) {
                                if (!roi.contains((double)x, (double)y, (double)z, (double)t, (double)c)) continue;
                                elements[elemCount++] = inputCursors[z].get(x, y, c);
                                continue block1;
                            }
                        }
                        lineElements[x] = elemCount == 0 ? 0.0 : this.computeResVal(Arrays.copyOf(elements, elemCount));
                    }
                    return lineElements;
                }));
            }
            try {
                for (line = 0; line < height; ++line) {
                    double[] lineElements = (double[])((Future)futureLines.get(line)).get();
                    for (int column = 0; column < width; ++column) {
                        outputCursor.setSafe(column, line, c, lineElements[column]);
                    }
                }
            }
            finally {
                outputCursor.commitChanges();
            }
            return resultVolume;
        };
    }

    private void startTProjection() throws InterruptedException, ExecutionException {
        int c;
        int z;
        int width = this.seq.getSizeX();
        int height = this.seq.getSizeY();
        int depth = this.seq.getSizeZ();
        int frames = this.seq.getSizeT();
        int channels = this.seq.getSizeC();
        ForkJoinPool generalTaskPool = (ForkJoinPool)Executors.newWorkStealingPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
        ForkJoinPool temporalTaskPool = (ForkJoinPool)Executors.newWorkStealingPool(Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        ArrayList<Future> futures = new ArrayList<Future>(depth);
        for (z = 0; z < depth; ++z) {
            for (c = 0; c < channels; ++c) {
                Sequence inputS = this.seq;
                Sequence resultS = this.result;
                futures.add(generalTaskPool.submit(this.getImageTProjectionTask(z, c, inputS, resultS, channels, height, width, depth, frames, temporalTaskPool)));
            }
        }
        generalTaskPool.shutdown();
        try {
            int pos = 0;
            for (z = 0; z < depth; ++z) {
                for (c = 0; c < channels; ++c) {
                    ((Future)futures.get(pos++)).get();
                }
                this.notifyProgress(0.01 + 0.99 * ((double)z / (double)depth), (Object)((Object)this.axis) + "-projection: Processed z=" + z);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            generalTaskPool.shutdownNow();
            throw e;
        }
        finally {
            temporalTaskPool.shutdown();
        }
    }

    private Callable<Sequence> getImageTProjectionTask(int z, int c, Sequence inputS, Sequence resultS, int channels, int height, int width, int depth, int frames, ForkJoinPool temporalTaskPool) {
        return () -> {
            IcyBufferedImageCursor[] inputCursors = new IcyBufferedImageCursor[frames];
            IcyBufferedImageCursor outputCursor = new IcyBufferedImageCursor(resultS.getImage(0, z));
            for (int frame = 0; frame < frames; ++frame) {
                inputCursors[frame] = new IcyBufferedImageCursor(inputS.getImage(frame, z));
            }
            ArrayList<Future> futureLines = new ArrayList<Future>(height);
            int line = 0;
            while (line < height) {
                int y = line++;
                futureLines.add(temporalTaskPool.submit(() -> {
                    double[] lineElements = new double[width];
                    double[] elements = new double[frames];
                    for (int x = 0; x < width; ++x) {
                        int elemCount = 0;
                        block1: for (int t = 0; t < frames; ++t) {
                            if (this.rois.isEmpty()) {
                                elements[elemCount++] = inputCursors[t].get(x, y, c);
                                continue;
                            }
                            for (ROI roi : this.rois) {
                                if (!roi.contains((double)x, (double)y, (double)z, (double)t, (double)c)) continue;
                                elements[elemCount++] = inputCursors[t].get(x, y, c);
                                continue block1;
                            }
                        }
                        lineElements[x] = elemCount == 0 ? 0.0 : this.computeResVal(Arrays.copyOf(elements, elemCount));
                    }
                    return lineElements;
                }));
            }
            try {
                for (line = 0; line < height; ++line) {
                    double[] lineElements = (double[])((Future)futureLines.get(line)).get();
                    for (int column = 0; column < width; ++column) {
                        outputCursor.setSafe(column, line, c, lineElements[column]);
                    }
                }
            }
            finally {
                outputCursor.commitChanges();
            }
            return resultS;
        };
    }

    private double computeResVal(double[] elements) {
        switch (this.op) {
            case MAX: {
                return ArrayMath.max((double[])elements);
            }
            case MEAN: {
                return ArrayMath.mean((double[])elements);
            }
            case MED: {
                if (elements.length == 1) {
                    return elements[0];
                }
                return ArrayMath.median((double[])elements, (boolean)false);
            }
            case MIN: {
                return ArrayMath.min((double[])elements);
            }
            case SATSUM: {
                return ArrayMath.sum((double[])elements);
            }
            case STD: {
                return ArrayMath.std((double[])elements, (boolean)true);
            }
        }
        return 0.0;
    }

    private void notifyProgress(double progress, String message) {
        this.progressListeners.forEach(l -> l.onProgress(progress, message));
    }

    private Sequence getResultSequence() {
        return this.result;
    }

    public void reset() {
        this.result = null;
        this.computed = false;
    }

    public static class Builder {
        private Sequence s;
        private List<ROI> rois;
        private ProjectionAxis axis;
        private ProjectionOperationType op;

        public Builder(Sequence s) {
            if (s == null || s.isEmpty()) {
                throw new IllegalArgumentException("Input sequence is null or empty.");
            }
            this.s = s;
            this.rois = new ArrayList<ROI>();
            this.axis = ProjectionAxis.Z;
            this.op = ProjectionOperationType.MAX;
        }

        public Builder addRoi(ROI roi) {
            this.rois.add(roi);
            return this;
        }

        public Builder addRois(Collection<? extends ROI> rois) {
            this.rois.addAll(rois);
            return this;
        }

        public Builder axis(ProjectionAxis axis) {
            this.axis = axis == null ? ProjectionAxis.Z : axis;
            return this;
        }

        public Builder operation(ProjectionOperationType op) {
            this.op = op == null ? ProjectionOperationType.MAX : op;
            return this;
        }

        public ProjectionCalculator build() {
            ProjectionCalculator calculator = new ProjectionCalculator();
            calculator.seq = this.s;
            calculator.rois = this.rois;
            calculator.axis = this.axis;
            calculator.op = this.op;
            return calculator;
        }
    }
}

