/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame;

import icy.action.IcyAbstractAction;
import icy.common.MenuCallback;
import icy.gui.util.ComponentUtil;
import icy.gui.util.LookAndFeelUtil;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;

public class IcyExternalFrame
extends JFrame {
    private static final long serialVersionUID = 9130936218505070807L;
    private SubstanceTitlePane titlePane;
    MenuCallback systemMenuCallback;
    private boolean titleBarVisible;
    private boolean closeItemVisible;
    private boolean initialized = false;

    public IcyExternalFrame(String title) throws HeadlessException {
        super(title);
        this.getRootPane().addPropertyChangeListener("titlePane", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ThreadUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IcyExternalFrame.this.updateTitlePane();
                    }
                });
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                IcyExternalFrame.this.systemMenuCallback = null;
            }
        });
        this.setIconImages(ResourceUtil.getIcyIconImages());
        this.setVisible(false);
        this.systemMenuCallback = null;
        this.closeItemVisible = true;
        this.updateTitlePane(LookAndFeelUtil.getTitlePane(this));
        this.titleBarVisible = true;
        this.initialized = true;
    }

    protected void updateTitlePane(SubstanceTitlePane pane) {
        if (pane != null) {
            this.titlePane = pane;
        }
        this.updateSystemMenu();
    }

    protected void updateTitlePane() {
        if (this.initialized) {
            this.updateTitlePane(LookAndFeelUtil.getTitlePane(this));
            if (!this.titleBarVisible) {
                this.setTitleBarVisible(false);
            }
        }
    }

    public void updateSystemMenu() {
        if (this.titlePane != null) {
            JMenu menu = this.systemMenuCallback != null ? this.systemMenuCallback.getMenu() : this.getDefaultSystemMenu();
            menu.getPopupMenu().setLightWeightPopupEnabled(false);
            this.titlePane.setSystemMenu(menu);
        }
    }

    public void setTitleBarVisible(boolean value) {
        if (value) {
            this.getRootPane().setWindowDecorationStyle(1);
        } else {
            this.getRootPane().setWindowDecorationStyle(0);
        }
        this.validate();
    }

    public void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public boolean isMinimized() {
        return ComponentUtil.isMinimized(this);
    }

    public boolean isMaximized() {
        return ComponentUtil.isMaximized(this);
    }

    public void setMinimized(boolean value) {
        ComponentUtil.setMinimized(this, value);
    }

    public void setMaximized(boolean value) {
        ComponentUtil.setMaximized(this, value);
    }

    public boolean isTitleBarVisible() {
        return this.getRootPane().getWindowDecorationStyle() != 0;
    }

    public boolean isCloseItemVisible() {
        return this.closeItemVisible;
    }

    public void setCloseItemVisible(boolean value) {
        if (this.closeItemVisible != value) {
            this.closeItemVisible = value;
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IcyExternalFrame.this.updateSystemMenu();
                }
            });
        }
    }

    public JMenu getDefaultSystemMenu() {
        JMenu result = new JMenu();
        if (this.closeItemVisible) {
            result.add(new CloseAction());
        }
        return result;
    }

    public MenuCallback getSystemMenuCallback() {
        return this.systemMenuCallback;
    }

    public void setSystemMenuCallback(MenuCallback value) {
        if (this.systemMenuCallback != value) {
            this.systemMenuCallback = value;
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IcyExternalFrame.this.updateSystemMenu();
                }
            });
        }
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        Rectangle r = new Rectangle(x, y, width, height);
        ComponentUtil.fixPosition(this, r);
        super.reshape(r.x, r.y, r.width, r.height);
    }

    private class CloseAction
    extends IcyAbstractAction {
        private static final long serialVersionUID = 4933605299188863452L;

        public CloseAction() {
            super("Close", new IcyIcon(ResourceUtil.ICON_CLOSE, 20), "Close window", 115, SystemUtil.getMenuCtrlMask());
        }

        @Override
        public boolean doAction(ActionEvent e) {
            IcyExternalFrame.this.close();
            return true;
        }
    }
}

