/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.component.NumberTextField;
import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.PreferencePanel;
import icy.preferences.MagicWandPreferences;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import plugins.kernel.roi.tool.MagicWand;

public class MagicWandPreferencePanel
extends PreferencePanel {
    public static final String NODE_NAME = "Magic Wand";
    private NumberTextField gradientToleranceValueField;
    private JComboBox connectivityField;
    private JComboBox gradientToleranceModeField;

    MagicWandPreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME, "Preferences");
        this.initGui();
        this.load();
    }

    private void initGui() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{160, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.mainPanel.setLayout(gridBagLayout);
        JLabel lblNewLabel = new JLabel("Connectivity");
        lblNewLabel.setToolTipText("Wagic Wand pixel connectivity method");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        this.mainPanel.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.connectivityField = new JComboBox();
        this.connectivityField.setToolTipText("Select connectivy method (default = 8 points)");
        this.connectivityField.setModel(new DefaultComboBoxModel<MagicWand.MagicWandConnectivity>(MagicWand.MagicWandConnectivity.values()));
        this.connectivityField.setSelectedIndex(1);
        GridBagConstraints gbc_connectivityField = new GridBagConstraints();
        gbc_connectivityField.fill = 2;
        gbc_connectivityField.insets = new Insets(0, 0, 5, 0);
        gbc_connectivityField.gridx = 1;
        gbc_connectivityField.gridy = 0;
        this.mainPanel.add((Component)this.connectivityField, gbc_connectivityField);
        JLabel lblNewLabel_1 = new JLabel("Gradient tolerance");
        lblNewLabel_1.setToolTipText("Gradient tolerance method to use (disabled by default)");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.anchor = 17;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_1.gridx = 0;
        gbc_lblNewLabel_1.gridy = 1;
        this.mainPanel.add((Component)lblNewLabel_1, gbc_lblNewLabel_1);
        this.gradientToleranceModeField = new JComboBox();
        this.gradientToleranceModeField.setToolTipText("Gradient tolerance mode");
        this.gradientToleranceModeField.setModel(new DefaultComboBoxModel<MagicWand.MagicWandGradientToleranceMode>(MagicWand.MagicWandGradientToleranceMode.values()));
        this.gradientToleranceModeField.setSelectedIndex(0);
        GridBagConstraints gbc_gradientToleranceModeField = new GridBagConstraints();
        gbc_gradientToleranceModeField.insets = new Insets(0, 0, 5, 0);
        gbc_gradientToleranceModeField.fill = 2;
        gbc_gradientToleranceModeField.gridx = 1;
        gbc_gradientToleranceModeField.gridy = 1;
        this.mainPanel.add((Component)this.gradientToleranceModeField, gbc_gradientToleranceModeField);
        JLabel lblNewLabel_2 = new JLabel("Gradient tolerance value");
        GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
        gbc_lblNewLabel_2.anchor = 17;
        gbc_lblNewLabel_2.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel_2.gridx = 0;
        gbc_lblNewLabel_2.gridy = 2;
        this.mainPanel.add((Component)lblNewLabel_2, gbc_lblNewLabel_2);
        this.gradientToleranceValueField = new NumberTextField();
        this.gradientToleranceValueField.setText("20");
        GridBagConstraints gbc_gradientToleranceValueField = new GridBagConstraints();
        gbc_gradientToleranceValueField.fill = 2;
        gbc_gradientToleranceValueField.gridx = 1;
        gbc_gradientToleranceValueField.gridy = 2;
        this.mainPanel.add((Component)this.gradientToleranceValueField, gbc_gradientToleranceValueField);
    }

    @Override
    protected void load() {
        this.gradientToleranceModeField.setSelectedItem((Object)MagicWandPreferences.getGradientToleranceMode());
        this.gradientToleranceValueField.setNumericValue(MagicWandPreferences.getGradientToleranceValue());
        this.connectivityField.setSelectedItem((Object)MagicWandPreferences.getConnectivity());
    }

    @Override
    protected void save() {
        MagicWandPreferences.setGradientToleranceMode((MagicWand.MagicWandGradientToleranceMode)((Object)this.gradientToleranceModeField.getSelectedItem()));
        MagicWandPreferences.setGradientToleranceValue(this.gradientToleranceValueField.getNumericValue());
        MagicWandPreferences.setConnectivity((MagicWand.MagicWandConnectivity)((Object)this.connectivityField.getSelectedItem()));
    }
}

