/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.dialog.ConfirmDialog;
import icy.gui.preferences.PluginListPreferencePanel;
import icy.gui.preferences.PreferenceFrame;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLoader;
import icy.plugin.PluginRepositoryLoader;
import icy.plugin.PluginUpdater;
import java.util.ArrayList;
import java.util.List;

public class PluginLocalPreferencePanel
extends PluginListPreferencePanel
implements PluginLoader.PluginLoaderListener,
PluginInstaller.PluginInstallerListener,
PluginRepositoryLoader.PluginRepositoryLoaderListener {
    private static final long serialVersionUID = -6732331255351202922L;
    public static final String NODE_NAME = "Local Plugin";

    PluginLocalPreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME, "Plugin");
        PluginRepositoryLoader.addListener(this);
        PluginLoader.addListener(this);
        PluginInstaller.addListener(this);
        this.table.removeColumn(this.table.getColumn(columnIds[4]));
        this.action1Button.setText("Delete");
        this.action1Button.setVisible(true);
        this.action2Button.setText("Check update");
        this.action2Button.setVisible(true);
        this.pluginsChanged();
    }

    @Override
    protected void closed() {
        super.closed();
        PluginRepositoryLoader.removeListener(this);
        PluginInstaller.removeListener(this);
        PluginLoader.removeListener(this);
    }

    private PluginLocalState getPluginLocalState(PluginDescriptor plugin) {
        if (plugin != null) {
            if (!PluginRepositoryLoader.isLoaded()) {
                return PluginLocalState.CHECKING_UPDATE;
            }
            if (PluginInstaller.isDesinstallingPlugin(plugin)) {
                return PluginLocalState.REMOVING;
            }
            PluginDescriptor onlinePlugin = PluginUpdater.getUpdate(plugin);
            if (onlinePlugin != null) {
                if (PluginInstaller.isInstallingPlugin(onlinePlugin)) {
                    return PluginLocalState.UPDATING;
                }
                return PluginLocalState.HAS_UPDATE;
            }
            if (plugin.isInstalled()) {
                return PluginLocalState.NO_UPDATE;
            }
            return PluginLocalState.REMOVING;
        }
        return PluginLocalState.NULL;
    }

    @Override
    protected void doAction1() {
        List<PluginDescriptor> selectedPlugins = this.getSelectedPlugins();
        ArrayList<PluginDescriptor> toRemove = new ArrayList<PluginDescriptor>();
        for (PluginDescriptor plugin : selectedPlugins) {
            if (PluginInstaller.isDesinstallingPlugin(plugin) || !plugin.isInstalled()) continue;
            toRemove.add(plugin);
        }
        if (toRemove.isEmpty()) {
            return;
        }
        List<PluginDescriptor> dependants = PluginInstaller.getLocalDependenciesFrom(toRemove);
        dependants.removeAll(toRemove);
        String message = "<html>";
        if (!dependants.isEmpty()) {
            message = message + "The following plugin(s) won't work anymore :<br>";
            for (PluginDescriptor depPlug : dependants) {
                message = message + depPlug.getName() + " " + depPlug.getVersion() + "<br>";
            }
            message = message + "<br>";
        }
        if (ConfirmDialog.confirm(message = message + "Are you sure you want to remove selected plugin(s) ?</html>")) {
            for (PluginDescriptor plugin : toRemove) {
                PluginInstaller.desinstall(plugin, false, true);
            }
        }
        this.refreshTableData();
    }

    @Override
    protected void doAction2() {
        List<PluginDescriptor> selectedPlugins = this.getSelectedPlugins();
        for (PluginDescriptor plugin : selectedPlugins) {
            PluginDescriptor onlinePlugin = PluginUpdater.getUpdate(plugin);
            if (onlinePlugin == null) continue;
            PluginInstaller.install(onlinePlugin, true);
        }
        this.refreshTableData();
    }

    @Override
    protected void repositoryChanged() {
    }

    @Override
    protected void reloadPlugins() {
        PluginLoader.reloadAsynch();
        this.pluginsChanged();
    }

    @Override
    protected String getStateValue(PluginDescriptor plugin) {
        if (plugin == null) {
            return "";
        }
        switch (this.getPluginLocalState(plugin)) {
            case REMOVING: {
                return "removing...";
            }
            case CHECKING_UPDATE: {
                return "checking...";
            }
            case UPDATING: {
                return "updating...";
            }
            case HAS_UPDATE: {
                return "update available";
            }
            case NO_UPDATE: {
                return "";
            }
        }
        return "";
    }

    @Override
    protected List<PluginDescriptor> getPlugins() {
        if (PluginLoader.isLoading()) {
            return new ArrayList<PluginDescriptor>();
        }
        ArrayList<PluginDescriptor> result = PluginLoader.getPlugins(false);
        for (int i = result.size() - 1; i >= 0; --i) {
            if (((PluginDescriptor)result.get(i)).isInstalled()) continue;
            result.remove(i);
        }
        return result;
    }

    @Override
    protected void updateButtonsStateInternal() {
        boolean selected;
        super.updateButtonsStateInternal();
        List<PluginDescriptor> selectedPlugins = this.getSelectedPlugins();
        boolean bl = selected = selectedPlugins.size() > 0;
        if (PluginLoader.isLoading()) {
            this.refreshButton.setText("Reloading...");
            this.refreshButton.setEnabled(false);
        } else {
            this.refreshButton.setText("Reload list");
            this.refreshButton.setEnabled(true);
        }
        if (!selected) {
            this.action1Button.setEnabled(false);
            this.action2Button.setEnabled(false);
            return;
        }
        boolean removing = true;
        for (PluginDescriptor pluginDescriptor : selectedPlugins) {
            if (PluginInstaller.isDesinstallingPlugin(pluginDescriptor)) continue;
            removing = false;
            break;
        }
        if (removing) {
            this.action1Button.setText("Removing...");
            this.action1Button.setEnabled(false);
        } else {
            this.action1Button.setText("Remove");
            this.action1Button.setEnabled(true);
        }
        PluginLocalState state = PluginLocalState.NULL;
        for (PluginDescriptor plugin : selectedPlugins) {
            switch (this.getPluginLocalState(plugin)) {
                case CHECKING_UPDATE: {
                    if (state != PluginLocalState.NULL && state != PluginLocalState.NO_UPDATE) break;
                    state = PluginLocalState.CHECKING_UPDATE;
                    break;
                }
                case UPDATING: {
                    if (state != PluginLocalState.NULL && state != PluginLocalState.NO_UPDATE && state != PluginLocalState.CHECKING_UPDATE) break;
                    state = PluginLocalState.UPDATING;
                    break;
                }
                case HAS_UPDATE: {
                    state = PluginLocalState.HAS_UPDATE;
                    break;
                }
                case NO_UPDATE: {
                    if (state != PluginLocalState.NULL) break;
                    state = PluginLocalState.NO_UPDATE;
                }
            }
        }
        switch (state) {
            case CHECKING_UPDATE: {
                this.action1Button.setEnabled(false);
                this.action2Button.setText("Checking...");
                this.action2Button.setEnabled(false);
                break;
            }
            case UPDATING: {
                this.action1Button.setEnabled(false);
                this.action2Button.setText("Updating...");
                this.action2Button.setEnabled(false);
                break;
            }
            case HAS_UPDATE: {
                this.action2Button.setText("Update");
                this.action2Button.setEnabled(true);
                break;
            }
            case NO_UPDATE: {
                this.action2Button.setText("No update");
                this.action2Button.setEnabled(false);
                break;
            }
            case NULL: {
                this.action1Button.setEnabled(false);
                this.action2Button.setEnabled(false);
            }
        }
        if (this.action1Button.isEnabled()) {
            boolean bl2;
            boolean bl3 = false;
            for (PluginDescriptor plugin : selectedPlugins) {
                if (!plugin.isInstalled()) continue;
                bl2 = true;
                break;
            }
            this.action1Button.setEnabled(bl2);
        }
    }

    @Override
    public void pluginLoaderChanged(PluginLoader.PluginLoaderEvent e) {
        this.pluginsChanged();
    }

    @Override
    public void pluginInstalled(PluginDescriptor plugin, boolean success) {
        this.updateButtonsState();
    }

    @Override
    public void pluginRemoved(PluginDescriptor plugin, boolean success) {
        this.updateButtonsState();
    }

    @Override
    public void pluginRepositeryLoaderChanged(PluginDescriptor plugin) {
        this.refreshTableData();
    }

    private static enum PluginLocalState {
        NULL,
        UPDATING,
        REMOVING,
        HAS_UPDATE,
        NO_UPDATE,
        CHECKING_UPDATE;

    }
}

