/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.roi.ROI;
import icy.roi.edit.AbstractROIEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class PropertyROIEdit
extends AbstractROIEdit {
    String propertyName;
    Object previousValue;
    Object currentValue;

    public PropertyROIEdit(ROI roi, String propertyName, Object previousValue, Object currentValue, boolean mergeable) {
        super(roi, "ROI " + propertyName + " changed");
        this.propertyName = propertyName;
        this.previousValue = previousValue;
        this.currentValue = currentValue;
        this.setMergeable(mergeable);
    }

    public PropertyROIEdit(ROI roi, String propertyName, Object previousValue, Object currentValue) {
        this(roi, propertyName, previousValue, currentValue, true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.getROI().setPropertyValue(this.propertyName, this.previousValue);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.getROI().setPropertyValue(this.propertyName, this.currentValue);
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        PropertyROIEdit propEdit;
        if (!this.isMergeable()) {
            return false;
        }
        if (edit instanceof PropertyROIEdit && (propEdit = (PropertyROIEdit)edit).getROI() == this.getROI() && propEdit.propertyName.equals(this.propertyName)) {
            this.currentValue = propEdit.currentValue;
            return true;
        }
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.previousValue = null;
        this.currentValue = null;
    }
}

