/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi4d;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.canvas.IcyCanvas3D;
import icy.painter.OverlayEvent;
import icy.painter.OverlayListener;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI3D;
import icy.roi.ROI4D;
import icy.roi.ROIEvent;
import icy.roi.ROIListener;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle4D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ROI4DStack<R extends ROI3D>
extends ROI4D
implements ROIListener,
OverlayListener,
Iterable<R> {
    public static final String PROPERTY_USECHILDCOLOR = "useChildColor";
    protected final TreeMap<Integer, R> slices = new TreeMap();
    protected final Class<R> roiClass;
    protected boolean useChildColor;
    protected Semaphore modifyingSlice;
    protected double translateT;

    public ROI4DStack(Class<R> roiClass) {
        this.roiClass = roiClass;
        this.useChildColor = false;
        this.modifyingSlice = new Semaphore(1);
        this.translateT = 0.0;
    }

    @Override
    public String getDefaultName() {
        return "ROI3D stack";
    }

    @Override
    protected ROI.ROIPainter createPainter() {
        return new ROI4DStackPainter();
    }

    protected R createSlice() {
        try {
            return (R)((ROI3D)this.roiClass.newInstance());
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, true, true);
            return null;
        }
    }

    public boolean getUseChildColor() {
        return this.useChildColor;
    }

    public void setUseChildColor(boolean value) {
        if (this.useChildColor != value) {
            this.useChildColor = value;
            this.propertyChanged(PROPERTY_USECHILDCOLOR);
            this.getOverlay().painterChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(int t, Color value) {
        R slice = this.getSlice(t);
        this.modifyingSlice.acquireUninterruptibly();
        try {
            if (slice != null) {
                ((ROI)slice).setColor(value);
            }
        }
        finally {
            this.modifyingSlice.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColor(Color value) {
        block10: {
            this.beginUpdate();
            try {
                super.setColor(value);
                if (this.getUseChildColor()) break block10;
                this.modifyingSlice.acquireUninterruptibly();
                try {
                    TreeMap<Integer, R> treeMap = this.slices;
                    synchronized (treeMap) {
                        for (ROI3D slice : this.slices.values()) {
                            slice.setColor(value);
                        }
                    }
                }
                finally {
                    this.modifyingSlice.release();
                }
            }
            finally {
                this.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOpacity(float value) {
        this.beginUpdate();
        try {
            super.setOpacity(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI3D slice : this.slices.values()) {
                        slice.setOpacity(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStroke(double value) {
        this.beginUpdate();
        try {
            super.setStroke(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI3D slice : this.slices.values()) {
                        slice.setStroke(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCreating(boolean value) {
        this.beginUpdate();
        try {
            super.setCreating(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI3D slice : this.slices.values()) {
                        slice.setCreating(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean value) {
        this.beginUpdate();
        try {
            super.setReadOnly(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI3D slice : this.slices.values()) {
                        slice.setReadOnly(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocused(boolean value) {
        this.beginUpdate();
        try {
            super.setFocused(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI3D slice : this.slices.values()) {
                        slice.setFocused(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelected(boolean value) {
        this.beginUpdate();
        try {
            super.setSelected(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI3D slice : this.slices.values()) {
                        slice.setSelected(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setC(int value) {
        this.beginUpdate();
        try {
            super.setC(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI3D slice : this.slices.values()) {
                        slice.setC(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.slices.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSizeT() {
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            if (this.slices.isEmpty()) {
                return 0;
            }
            return this.slices.lastKey() - this.slices.firstKey() + 1;
        }
    }

    public R getSlice(int t) {
        return (R)((ROI3D)this.slices.get(t));
    }

    public R getSlice(int t, boolean createIfNull) {
        R result = this.getSlice(t);
        if (result == null && createIfNull && (result = this.createSlice()) != null) {
            this.setSlice(t, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlice(int t, R roi3d) {
        if (roi3d == null) {
            throw new IllegalArgumentException("Cannot set an empty slice in a 4D ROI");
        }
        ((ROI)roi3d).beginUpdate();
        try {
            ((ROI3D)roi3d).setT(t);
            ((ROI3D)roi3d).setC(this.getC());
        }
        finally {
            ((ROI)roi3d).endUpdate();
        }
        ((ROI)roi3d).addListener(this);
        ((ROI)roi3d).getOverlay().addOverlayListener(this);
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            this.slices.put(t, roi3d);
        }
        this.roiChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R removeSlice(int t) {
        ROI3D result;
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            result = (ROI3D)this.slices.remove(t);
        }
        if (result != null) {
            result.removeListener(this);
            result.getOverlay().removeOverlayListener(this);
        }
        this.roiChanged(true);
        return (R)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            for (ROI3D slice : this.slices.values()) {
                slice.removeListener(this);
                slice.getOverlay().removeOverlayListener(this);
            }
            this.slices.clear();
        }
        this.roiChanged(true);
    }

    protected void sliceChanged(ROIEvent event) {
        if (this.modifyingSlice.availablePermits() <= 0) {
            return;
        }
        ROI source = event.getSource();
        switch (event.getType()) {
            case ROI_CHANGED: {
                this.roiChanged(true);
                break;
            }
            case FOCUS_CHANGED: {
                this.setFocused(source.isFocused());
                break;
            }
            case SELECTION_CHANGED: {
                this.setSelected(source.isSelected());
                break;
            }
            case PROPERTY_CHANGED: {
                String propertyName = event.getPropertyName();
                if (propertyName == null || propertyName.equals("readOnly")) {
                    this.setReadOnly(source.isReadOnly());
                }
                if (propertyName != null && !propertyName.equals("creating")) break;
                this.setCreating(source.isCreating());
            }
        }
    }

    protected void sliceOverlayChanged(OverlayEvent event) {
        switch (event.getType()) {
            case PAINTER_CHANGED: {
                this.getOverlay().painterChanged();
                break;
            }
            case PROPERTY_CHANGED: {
                this.getOverlay().propertyChanged(event.getPropertyName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle4D computeBounds4D() {
        int sizeT;
        int t;
        Rectangle3D xyzBounds = null;
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            for (ROI3D slice : this.slices.values()) {
                Rectangle3D bnd3d = slice.getBounds3D();
                if (bnd3d.isEmpty()) continue;
                if (xyzBounds == null) {
                    xyzBounds = (Rectangle3D)bnd3d.clone();
                    continue;
                }
                xyzBounds.add(bnd3d);
            }
        }
        if (xyzBounds == null) {
            xyzBounds = new Rectangle3D.Double();
        }
        TreeMap<Integer, R> treeMap2 = this.slices;
        synchronized (treeMap2) {
            if (!this.slices.isEmpty()) {
                t = this.slices.firstKey();
                sizeT = this.getSizeT();
            } else {
                t = 0;
                sizeT = 0;
            }
        }
        return new Rectangle4D.Double(xyzBounds.getX(), xyzBounds.getY(), xyzBounds.getZ(), t, xyzBounds.getSizeX(), xyzBounds.getSizeY(), xyzBounds.getSizeZ(), sizeT);
    }

    @Override
    public boolean contains(double x, double y, double z, double t) {
        R roi3d = this.getSlice((int)Math.floor(t));
        if (roi3d != null) {
            return ((ROI3D)roi3d).contains(x, y, z);
        }
        return false;
    }

    @Override
    public boolean contains(double x, double y, double z, double t, double sizeX, double sizeY, double sizeZ, double sizeT) {
        Rectangle4D bounds = this.getBounds4D();
        if (!bounds.contains(x, y, z, t, sizeX, sizeY, sizeZ, sizeT)) {
            return false;
        }
        int lim = (int)Math.floor(t + sizeT);
        for (int tc = (int)Math.floor(t); tc < lim; ++tc) {
            R roi3d = this.getSlice(tc);
            if (roi3d != null && ((ROI3D)roi3d).contains(x, y, z, sizeX, sizeY, sizeZ)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(double x, double y, double z, double t, double sizeX, double sizeY, double sizeZ, double sizeT) {
        Rectangle4D bounds = this.getBounds4D();
        if (!bounds.intersects(x, y, z, t, sizeX, sizeY, sizeZ, sizeT)) {
            return false;
        }
        int lim = (int)Math.floor(t + sizeT);
        for (int tc = (int)Math.floor(t); tc < lim; ++tc) {
            R roi3d = this.getSlice(tc);
            if (roi3d == null || !((ROI3D)roi3d).intersects(x, y, z, sizeX, sizeY, sizeZ)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSelectedPoint() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unselectAllPoints() {
        this.beginUpdate();
        try {
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI3D slice : this.slices.values()) {
                        slice.unselectAllPoints();
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double computeNumberOfContourPoints() {
        double result = 0.0;
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            if (this.slices.size() <= 2) {
                for (ROI3D slice : this.slices.values()) {
                    result += slice.getNumberOfPoints();
                }
            } else {
                Map.Entry<Integer, R> firstEntry = this.slices.firstEntry();
                Map.Entry<Integer, R> lastEntry = this.slices.lastEntry();
                Integer firstKey = firstEntry.getKey();
                Integer lastKey = lastEntry.getKey();
                result = ((ROI3D)firstEntry.getValue()).getNumberOfPoints();
                for (ROI3D slice : this.slices.subMap(firstKey, false, lastKey, false).values()) {
                    result += slice.getNumberOfContourPoints();
                }
                result += ((ROI3D)lastEntry.getValue()).getNumberOfPoints();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double computeNumberOfPoints() {
        double volume = 0.0;
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            for (ROI3D slice : this.slices.values()) {
                volume += slice.getNumberOfPoints();
            }
        }
        return volume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canTranslate() {
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            if (!this.slices.isEmpty()) {
                return ((ROI3D)this.slices.firstEntry().getValue()).canTranslate();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(int t) {
        if (t == 0 || this.isEmpty()) {
            return;
        }
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            HashMap<Integer, R> map = new HashMap<Integer, R>(this.slices);
            this.slices.clear();
            for (Map.Entry entry : map.entrySet()) {
                ROI3D roi = (ROI3D)entry.getValue();
                int newT = roi.getT() + t;
                if (newT < 0) continue;
                roi.setT(newT);
                this.slices.put(newT, roi);
            }
        }
        this.roiChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translate(double dx, double dy, double dz, double dt) {
        this.beginUpdate();
        try {
            this.translateT += dt;
            int dti = (int)this.translateT;
            this.translateT -= (double)dti;
            this.translate(dti);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI3D slice : this.slices.values()) {
                        slice.translate(dx, dy, dz);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
            if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
                this.roiChanged(false);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, int t, boolean inclusive) {
        R roi3d = this.getSlice(t);
        if (roi3d != null) {
            return ((ROI3D)roi3d).getBooleanMask2D(x, y, width, height, z, inclusive);
        }
        return new boolean[width * height];
    }

    @Override
    public BooleanMask2D getBooleanMask2D(int z, int t, boolean inclusive) {
        R roi3d = this.getSlice(t);
        if (roi3d != null) {
            return ((ROI3D)roi3d).getBooleanMask2D(z, inclusive);
        }
        return new BooleanMask2D(new Rectangle(), new boolean[0]);
    }

    @Override
    public void roiChanged(ROIEvent event) {
        this.sliceChanged(event);
    }

    @Override
    public void overlayChanged(OverlayEvent event) {
        this.sliceOverlayChanged(event);
    }

    @Override
    public Iterator<R> iterator() {
        return this.slices.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.clear();
            for (Element e : XMLUtil.getElements(node, "slice")) {
                R slice = this.createSlice();
                if (slice == null || !((ROI3D)slice).loadFromXML(e)) {
                    boolean bl = false;
                    return bl;
                }
                this.setSlice(((ROI3D)slice).getT(), slice);
            }
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            for (ROI3D slice : this.slices.values()) {
                Element sliceNode;
                if (slice.saveToXML(sliceNode = XMLUtil.addElement(node, "slice"))) continue;
                return false;
            }
        }
        return true;
    }

    public class ROI4DStackPainter
    extends ROI.ROIPainter {
        R getSliceForCanvas(IcyCanvas canvas) {
            int t = canvas.getPositionT();
            if (t >= 0) {
                return ROI4DStack.this.getSlice(t);
            }
            return null;
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            Object slice;
            super.paint(g, sequence, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && !(canvas instanceof IcyCanvas3D) && canvas instanceof IcyCanvas2D && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().paint(g, sequence, canvas);
            }
        }

        @Override
        public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            Object slice;
            super.keyPressed(e, imagePoint, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().keyPressed(e, imagePoint, canvas);
            }
        }

        @Override
        public void keyReleased(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            Object slice;
            super.keyReleased(e, imagePoint, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().keyReleased(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            Object slice;
            super.mouseEntered(e, imagePoint, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().mouseEntered(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseExited(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            Object slice;
            super.mouseExited(e, imagePoint, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().mouseExited(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            Object slice;
            super.mouseMove(e, imagePoint, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().mouseMove(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            Object slice;
            super.mouseDrag(e, imagePoint, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().mouseDrag(e, imagePoint, canvas);
            }
        }

        @Override
        public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            Object slice;
            super.mousePressed(e, imagePoint, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().mousePressed(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            Object slice;
            super.mouseReleased(e, imagePoint, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().mouseReleased(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            Object slice;
            super.mouseClick(e, imagePoint, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().mouseClick(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            Object slice;
            super.mouseWheelMoved(e, imagePoint, canvas);
            if (ROI4DStack.this.isActiveFor(canvas) && (slice = this.getSliceForCanvas(canvas)) != null) {
                ((ROI)slice).getOverlay().mouseWheelMoved(e, imagePoint, canvas);
            }
        }
    }
}

