/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.tool;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas3D;
import icy.gui.lut.LUTViewer;
import icy.preferences.MagicWandPreferences;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import icy.util.EventUtil;
import icy.util.GraphicsUtil;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.tool.MagicWand;

public class ROIMagicWand
extends ROI2DArea {
    boolean force3d = false;
    MagicWandProcess processor = null;
    boolean inProcess = false;
    Point2D startImagePosition;
    Point startMousePosition;
    Sequence seq;
    double channelDelta;
    double startValueTolerance;
    double valueToleranceStep;
    ROI result = null;
    ROI roiAdded = null;
    MagicWand.MagicWandSetting lastSettings = null;

    public ROIMagicWand(Point5D pt) {
        super(pt);
    }

    public ROIMagicWand() {
        this(new Point5D.Double());
    }

    @Override
    public String getDefaultName() {
        return "Magic Wand";
    }

    public void start(Point5D.Double imagePoint, Point mousePoint, Sequence s, IcyCanvas canvas, boolean rgb) {
        if (this.processor != null && this.processor.isAlive()) {
            return;
        }
        if (s == null) {
            return;
        }
        this.seq = s;
        if (canvas instanceof IcyCanvas3D) {
            this.force3d = true;
        }
        this.startImagePosition = imagePoint.toPoint2D();
        this.startMousePosition = new Point(mousePoint);
        this.z = this.force3d ? (int)imagePoint.getZ() : canvas.getPositionZ();
        this.t = canvas.getPositionT();
        this.updateSettings(canvas, rgb, true);
        this.lastSettings = ROIMagicWand.getSettings(this.startValueTolerance, this.c == -1 ? 90.0 : -100.0);
        this.processor = new MagicWandProcess(this.seq, (int)imagePoint.getX(), (int)imagePoint.getY(), this.z, this.t, this.c, this.force3d, this.lastSettings);
        this.inProcess = true;
        this.result = null;
        this.getOverlay().painterChanged();
    }

    @Override
    protected ROI2DArea.ROI2DAreaPainter createPainter() {
        return new ROIMagicWandPainter();
    }

    public void setForce3d(boolean value) {
        this.force3d = value;
    }

    void updateSettings(IcyCanvas canvas, boolean rgb, boolean init) {
        LUTViewer lv;
        this.c = rgb && this.seq.getSizeC() == 3 ? -1 : ((lv = canvas.getViewer().getLutViewer()) != null ? lv.getActiveChannelIndex() : 0);
        double[] channelBounds = this.c == -1 ? this.seq.getChannelsGlobalBounds() : this.seq.getChannelBounds(this.c);
        this.channelDelta = channelBounds[1] - channelBounds[0];
        if (init) {
            this.startValueTolerance = this.channelDelta > 0.0 ? this.channelDelta / 15.0 : 1.0;
        }
        this.valueToleranceStep = this.channelDelta > 0.0 ? this.channelDelta / 800.0 : 0.0;
    }

    static MagicWand.MagicWandSetting getSettings(double valueTolerance, double colorSensitivity) {
        MagicWand.MagicWandSetting settings = new MagicWand.MagicWandSetting();
        settings.colorSensitivity = colorSensitivity;
        settings.connectivity = MagicWandPreferences.getConnectivity();
        settings.valueTolerance = valueTolerance;
        switch (MagicWandPreferences.getGradientToleranceMode()) {
            default: {
                settings.gradientTolerance = 0.0;
                break;
            }
            case FIXED: {
                settings.gradientTolerance = MagicWandPreferences.getGradientToleranceValue();
                break;
            }
            case P05: {
                settings.gradientTolerance = valueTolerance * 0.05;
                break;
            }
            case P10: {
                settings.gradientTolerance = valueTolerance * 0.1;
                break;
            }
            case P15: {
                settings.gradientTolerance = valueTolerance * 0.15;
                break;
            }
            case P20: {
                settings.gradientTolerance = valueTolerance * 0.2;
                break;
            }
            case P25: {
                settings.gradientTolerance = valueTolerance * 0.25;
                break;
            }
            case P33: {
                settings.gradientTolerance = valueTolerance * 0.33;
                break;
            }
            case P40: {
                settings.gradientTolerance = valueTolerance * 0.4;
                break;
            }
            case P50: {
                settings.gradientTolerance = valueTolerance * 0.5;
            }
        }
        return settings;
    }

    void adjustTolerances(Point mousePoint, IcyCanvas canvas, boolean rgb) {
        if (this.processor != null) {
            this.processor.interrupt();
        }
        this.updateSettings(canvas, rgb, false);
        double deltaX = mousePoint.getX() - this.startMousePosition.getX();
        double valueTolerance = this.startValueTolerance + deltaX * this.valueToleranceStep;
        this.lastSettings = ROIMagicWand.getSettings(valueTolerance, this.c == -1 ? 90.0 : -100.0);
        this.processor = new MagicWandProcess(this.seq, (int)this.startImagePosition.getX(), (int)this.startImagePosition.getY(), this.z, this.t, this.c, this.force3d, this.lastSettings);
        this.getOverlay().painterChanged();
    }

    void magicWandDone(ROI roi) {
        if (roi != null) {
            this.result = roi;
            this.result.setSelected(false);
            if (this.inProcess) {
                this.getOverlay().painterChanged();
            } else if (this.seq != null) {
                if (this.roiAdded != null) {
                    this.seq.removeROI(this.roiAdded, false);
                }
                this.seq.addROI(this.result, true);
                this.roiAdded = this.result;
            }
            if (roi instanceof ROI2D) {
                this.setAsBooleanMask(((ROI2D)roi).getBooleanMask(true));
            }
        }
    }

    public class ROIMagicWandPainter
    extends ROI2DArea.ROI2DAreaPainter {
        @Override
        public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (imagePoint == null) {
                return;
            }
            if (!EventUtil.isLeftMouseButton(e)) {
                return;
            }
            ROIMagicWand.this.start(imagePoint, e.getPoint(), canvas.getSequence(), canvas, EventUtil.isShiftDown(e));
            e.consume();
        }

        @Override
        public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (imagePoint == null) {
                return;
            }
            if (!EventUtil.isLeftMouseButton(e)) {
                return;
            }
            if (ROIMagicWand.this.inProcess) {
                ROIMagicWand.this.adjustTolerances(e.getPoint(), canvas, EventUtil.isShiftDown(e));
                e.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (!EventUtil.isLeftMouseButton(e)) {
                return;
            }
            ROIMagicWand.this.inProcess = false;
            ROIMagicWand.this.remove(false);
            if (ROIMagicWand.this.result != null) {
                ROIMagicWand.this.seq.addROI(ROIMagicWand.this.result, true);
                ROIMagicWand.this.roiAdded = ROIMagicWand.this.result;
            }
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (g == null) {
                return;
            }
            this.paintAnchor(g, canvas);
            if (ROIMagicWand.this.result != null) {
                ROIMagicWand.this.result.getOverlay().paint(g, sequence, canvas);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void paintAnchor(Graphics2D g, IcyCanvas canvas) {
            MagicWand.MagicWandSetting mws = ROIMagicWand.this.lastSettings;
            if (mws == null) {
                return;
            }
            if (!(canvas instanceof Canvas2D)) {
                return;
            }
            Canvas2D cnv2d = (Canvas2D)canvas;
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.transform(cnv2d.getInverseTransform());
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int size = 8;
                int x = ROIMagicWand.this.startMousePosition.x - 3;
                int y = ROIMagicWand.this.startMousePosition.y - 3;
                g2.setColor(Color.darkGray);
                g2.fillOval(x - 1, y - 1, 10, 10);
                g2.setColor(Color.red);
                g2.fillOval(x, y, 8, 8);
                String text = mws.colorSensitivity > 0.0 ? "Magic Wand - Color mode\n" : "Magic Wand - Gray mode\n";
                text = text + "Value tolerance = " + StringUtil.toString(mws.valueTolerance, 2) + "\n";
                text = text + "Gradient tolerance = " + StringUtil.toString(mws.gradientTolerance, 2);
                this.drawText(g2, cnv2d, text, 0.8f);
            }
            finally {
                g2.dispose();
            }
        }

        public void drawText(Graphics2D g, Canvas2D canvas2d, String text, float alpha) {
            Rectangle2D rect = GraphicsUtil.getStringBounds(g, text);
            int w = (int)rect.getWidth();
            int h = (int)rect.getHeight();
            int x = (int)((double)canvas2d.getWidth() - (rect.getWidth() + 20.0));
            int y = (int)((double)canvas2d.getHeight() - (rect.getHeight() + 30.0));
            GraphicsUtil.drawHint(g, text, x, y, Color.lightGray, Color.black);
        }
    }

    private class MagicWandProcess
    extends Thread {
        final Sequence sequence;
        final int x;
        final int y;
        final int z;
        final int t;
        final int channel;
        final boolean in3D;
        final MagicWand.MagicWandSetting settings;

        public MagicWandProcess(Sequence sequence, int x, int y, int z, int t, int channel, boolean in3D, MagicWand.MagicWandSetting mws) {
            super("Magic wand");
            this.sequence = sequence;
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.channel = channel;
            this.in3D = in3D;
            this.settings = mws;
            this.start();
        }

        @Override
        public void run() {
            ROI roi = this.in3D ? MagicWand.doWand3D(this.sequence, this.x, this.y, this.z, this.t, this.channel, this.settings) : MagicWand.doWand2D(this.sequence, this.x, this.y, this.z, this.t, this.channel, this.settings);
            ROIMagicWand.this.magicWandDone(roi);
        }
    }
}

