/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte2D;
import mitiv.array.Double2D;
import mitiv.array.Float2D;
import mitiv.array.Int2D;
import mitiv.array.Long1D;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatLong2D;
import mitiv.array.impl.StriddenLong2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public abstract class Long2D
extends Array2D
implements LongArray {
    protected Long2D(int dim1, int dim2) {
        super(dim1, dim2);
    }

    protected Long2D(int[] dims) {
        super(dims);
    }

    protected Long2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 3;
    }

    public abstract long get(int var1, int var2);

    public abstract void set(int var1, int var2, long var3);

    @Override
    public void fill(long value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, value);
                }
            }
        }
    }

    @Override
    public void increment(long value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, this.get(i1, i2) + value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, this.get(i1, i2) + value);
                }
            }
        }
    }

    @Override
    public void decrement(long value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, this.get(i1, i2) - value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, this.get(i1, i2) - value);
                }
            }
        }
    }

    @Override
    public void scale(long value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, this.get(i1, i2) * value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, this.get(i1, i2) * value);
                }
            }
        }
    }

    @Override
    public void map(LongFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                }
            }
        }
    }

    @Override
    public void fill(LongGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, generator.nextLong());
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, generator.nextLong());
                }
            }
        }
    }

    @Override
    public void scan(LongScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                        continue;
                    }
                    scanner.initialize(this.get(i1, i2));
                    initialized = true;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                        continue;
                    }
                    scanner.initialize(this.get(i1, i2));
                    initialized = true;
                }
            }
        }
    }

    @Override
    public final long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public long min() {
        long minValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    long value = this.get(i1, i2);
                    if (value >= minValue) continue;
                    minValue = value;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    long value = this.get(i1, i2);
                    if (value >= minValue) continue;
                    minValue = value;
                }
            }
        }
        return minValue;
    }

    @Override
    public long max() {
        long maxValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    long value = this.get(i1, i2);
                    if (value <= maxValue) continue;
                    maxValue = value;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    long value = this.get(i1, i2);
                    if (value <= maxValue) continue;
                    maxValue = value;
                }
            }
        }
        return maxValue;
    }

    @Override
    public long[] getMinAndMax() {
        long[] result = new long[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(long[] mm) {
        long minValue;
        long maxValue = minValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    long value = this.get(i1, i2);
                    if (value < minValue) {
                        minValue = value;
                    }
                    if (value <= maxValue) continue;
                    maxValue = value;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    long value = this.get(i1, i2);
                    if (value < minValue) {
                        minValue = value;
                    }
                    if (value <= maxValue) continue;
                    maxValue = value;
                }
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public long sum() {
        long totalValue = 0L;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    totalValue += this.get(i1, i2);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    totalValue += this.get(i1, i2);
                }
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        byte[] out = new byte[this.number];
        if (this.isFlat()) {
            long[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (byte)inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = (byte)this.get(i1, i2);
                }
            }
        }
        return Byte2D.wrap(out, this.getShape());
    }

    @Override
    public Short2D toShort() {
        short[] out = new short[this.number];
        if (this.isFlat()) {
            long[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (short)inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = (short)this.get(i1, i2);
                }
            }
        }
        return Short2D.wrap(out, this.getShape());
    }

    @Override
    public Int2D toInt() {
        int[] out = new int[this.number];
        if (this.isFlat()) {
            long[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (int)inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = (int)this.get(i1, i2);
                }
            }
        }
        return Int2D.wrap(out, this.getShape());
    }

    @Override
    public Long2D toLong() {
        return this;
    }

    @Override
    public Float2D toFloat() {
        float[] out = new float[this.number];
        if (this.isFlat()) {
            long[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = this.get(i1, i2);
                }
            }
        }
        return Float2D.wrap(out, this.getShape());
    }

    @Override
    public Double2D toDouble() {
        double[] out = new double[this.number];
        if (this.isFlat()) {
            long[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = this.get(i1, i2);
                }
            }
        }
        return Double2D.wrap(out, this.getShape());
    }

    @Override
    public Long2D copy() {
        return new FlatLong2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Long2D src = arr.getType() == 3 ? (Long2D)arr : (Long2D)arr.toLong();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, src.get(i1, i2));
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, src.get(i1, i2));
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, (long)src.get(++i));
                }
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, (long)src.get(++i));
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Long2D create() {
        return new FlatLong2D(this.getShape());
    }

    public static Long2D create(int dim1, int dim2) {
        return new FlatLong2D(dim1, dim2);
    }

    public static Long2D create(int[] dims) {
        return new FlatLong2D(dims);
    }

    public static Long2D create(Shape shape) {
        return new FlatLong2D(shape);
    }

    public static Long2D wrap(long[] data, int dim1, int dim2) {
        return new FlatLong2D(data, dim1, dim2);
    }

    public static Long2D wrap(long[] data, int[] dims) {
        return new FlatLong2D(data, dims);
    }

    public static Long2D wrap(long[] data, Shape shape) {
        return new FlatLong2D(data, shape);
    }

    public static Long2D wrap(long[] data, int offset, int stride1, int stride2, int dim1, int dim2) {
        return new StriddenLong2D(data, offset, stride1, stride2, dim1, dim2);
    }

    @Override
    public abstract Long1D slice(int var1);

    @Override
    public abstract Long1D slice(int var1, int var2);

    @Override
    public abstract Long2D view(Range var1, Range var2);

    @Override
    public abstract Long2D view(int[] var1, int[] var2);

    @Override
    public abstract Long1D as1D();
}

