/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.distancetransforms;

import icy.common.Version;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.type.DataIterator;
import icy.type.DataIteratorUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.util.OMEUtil;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import ome.xml.meta.MetadataRetrieve;
import plugins.adufour.distancetransforms.DistanceTransform;
import plugins.adufour.roi.mesh.ROI3DMesh;
import plugins.kernel.roi.roi3d.ROI3DArea;
import plugins.kernel.roi.roi3d.ROI3DStack;

public abstract class ChamferDistanceTransform
extends DistanceTransform {
    @Override
    public Sequence createDistanceMap(Sequence input, int channel, double threshold, boolean invertMap, boolean useRealUnits) {
        int width = input.getSizeX();
        int height = input.getSizeY();
        int depth = input.getSizeZ();
        int time = input.getSizeT();
        DataType type = input.getDataType_();
        int maxDistance = width * height * depth;
        Sequence output = new Sequence("Distance map of " + input.getName());
        for (int t = 0; t < time; ++t) {
            for (int z = 0; z < depth; ++z) {
                output.setImage(t, z, (BufferedImage)new IcyBufferedImage(width, height, 1, DataType.FLOAT));
            }
            float[][] map = output.getDataXYZAsFloat(t, 0);
            for (int z = 0; z < depth; ++z) {
                int i;
                float[] mapSlice = map[z];
                Object in = input.getDataXY(t, z, channel);
                if (invertMap) {
                    for (i = 0; i < mapSlice.length; ++i) {
                        if (!(Array1DUtil.getValue((Object)in, (int)i, (DataType)type) > threshold)) continue;
                        mapSlice[i] = maxDistance;
                    }
                    continue;
                }
                for (i = 0; i < mapSlice.length; ++i) {
                    if (!(Array1DUtil.getValue((Object)in, (int)i, (DataType)type) <= threshold)) continue;
                    mapSlice[i] = maxDistance;
                }
            }
        }
        this.updateUnsignedChamferDistance(output, useRealUnits);
        output.dataChanged();
        return output;
    }

    @Override
    public Sequence createDistanceMap(Sequence sequence, boolean mapOnlySelectedROI, boolean invertMap, boolean useRealUnits) {
        ArrayList rois = mapOnlySelectedROI ? sequence.getSelectedROIs() : sequence.getROIs();
        String title = "Distance map ";
        title = title + "(in " + (useRealUnits ? "microns)" : "pixels)");
        title = title + " to ROI from " + sequence.getName();
        Sequence output = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)sequence.getOMEXMLMetadata()), title);
        int width = sequence.getSizeX();
        int height = sequence.getSizeY();
        int depth = sequence.getSizeZ();
        int length = sequence.getSizeT();
        int maxDistance = width * height * depth;
        for (int t = 0; t < length; ++t) {
            for (int z = 0; z < depth; ++z) {
                float[] slice = new float[width * height];
                if (!invertMap) {
                    Arrays.fill(slice, (float)maxDistance);
                }
                output.setImage(t, z, (BufferedImage)new IcyBufferedImage(width, height, (Object[])new float[][]{slice}));
            }
        }
        if (!invertMap) {
            maxDistance = 0;
        }
        Version patch = new Version(1, 8, 6);
        for (ROI r : rois) {
            if (Icy.version.isLowerOrEqual(patch) && r instanceof ROI3DStack) {
                ROI3DStack stack = (ROI3DStack)r;
                for (ROI2D slice : stack) {
                    SequenceDataIterator iterator = new SequenceDataIterator(output, (ROI)slice, true);
                    DataIteratorUtil.set((DataIterator)iterator, (double)maxDistance);
                }
                continue;
            }
            if (r instanceof ROI3DMesh) {
                ROI3DArea rea = new ROI3DArea(((ROI3D)r).getBooleanMask(true));
                rea.setC(((ROI3D)r).getC());
                rea.setT(((ROI3D)r).getT());
                SequenceDataIterator iterator = new SequenceDataIterator(output, r, true);
                DataIteratorUtil.set((DataIterator)iterator, (double)maxDistance);
                continue;
            }
            SequenceDataIterator iterator = new SequenceDataIterator(output, r, true);
            DataIteratorUtil.set((DataIterator)iterator, (double)maxDistance);
        }
        this.updateUnsignedChamferDistance(output, useRealUnits);
        output.dataChanged();
        return output;
    }

    private void updateUnsignedChamferDistance(final Sequence output, boolean useRealUnits) {
        final int width = output.getSizeX();
        int length = output.getSizeT();
        final float stepXY = (float)(useRealUnits ? output.getPixelSizeX() : 1.0);
        final float stepZ = (float)(useRealUnits ? output.getPixelSizeZ() : 1.0);
        ArrayList<Future<Object>> results = new ArrayList<Future<Object>>(length);
        int t = 0;
        while (t < length) {
            final int n = t++;
            results.add(multiThreadService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    float[][] map = output.getDataXYZAsFloat(n, 0);
                    if (map.length == 1) {
                        ChamferDistanceTransform.this.updateUnsignedChamferDistance2D(map[0], width, stepXY);
                    } else {
                        ChamferDistanceTransform.this.updateUnsignedChamferDistance3D(map, width, stepXY, stepZ);
                    }
                    return null;
                }
            }));
        }
        try {
            for (Future future : results) {
                future.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void updateUnsignedChamferDistance2D(float[] var1, int var2, float var3);

    public abstract void updateUnsignedChamferDistance3D(float[][] var1, int var2, float var3, float var4);
}

