/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.math.ArrayMath;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugins.adufour.roi.ROIMeasures;

public class ROIHaralickTextureDescriptor
extends Plugin
implements PluginROIDescriptor,
PluginBundled {
    public static final ROIDescriptor angularSecondMoment = new ROIAngularSecondMoment();
    public static final ROIDescriptor contrast = new ROIContrast();
    public static final ROIDescriptor entropy = new ROIEntropy();
    public static final ROIDescriptor homogeneity = new ROIHomogeneity();

    public List<ROIDescriptor> getDescriptors() {
        ArrayList<ROIDescriptor> descriptors = new ArrayList<ROIDescriptor>();
        descriptors.add(angularSecondMoment);
        descriptors.add(contrast);
        descriptors.add(entropy);
        descriptors.add(homogeneity);
        return descriptors;
    }

    public Map<ROIDescriptor, Object> compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        if (!(roi instanceof ROI2D)) {
            throw new UnsupportedOperationException("(More than 2)-D ROI are not supported");
        }
        return ROIHaralickTextureDescriptor.computeHaralickFeatures(sequence, (ROI2D)roi, 1);
    }

    public static Map<ROIDescriptor, Object> computeHaralickFeatures(Sequence sequence, ROI2D roi, int step) {
        int z;
        int c = roi.getC();
        if (c == -1) {
            throw new UnsupportedOperationException("Texture can only be calculated on a single channel");
        }
        int t = roi.getT();
        if (t == -1) {
            if (sequence.getSizeT() > 1) {
                throw new UnsupportedOperationException("Texture can only be calculated on a single frame");
            }
            t = 0;
        }
        if ((z = roi.getZ()) == -1) {
            if (sequence.getSizeZ() > 1) {
                throw new UnsupportedOperationException("Texture can only be calculated on a single slice");
            }
            z = 0;
        }
        HashMap<ROIDescriptor, Object> descriptors = new HashMap<ROIDescriptor, Object>();
        IcyBufferedImage image = sequence.getImage(t, z, c);
        if (image == null) {
            return descriptors;
        }
        IcyBufferedImage cooc = ROIHaralickTextureDescriptor.buildGLCM(image, roi, step);
        double[] _cooc = cooc.getDataXYAsDouble(0);
        double _angularSecondMoment = 0.0;
        double _contrast = 0.0;
        double _entropy = 0.0;
        double _homogeneity = 0.0;
        int diagOffset = 0;
        int offset = 1;
        for (int j = 0; j < 256; ++j) {
            double value = _cooc[diagOffset];
            _angularSecondMoment += value * value;
            _entropy += value * Math.log(value + 1.0E-4);
            _homogeneity += value;
            int i = j + 1;
            while (i < 256) {
                value = _cooc[offset];
                _angularSecondMoment += 2.0 * value * value;
                _entropy += 2.0 * value * Math.log(value + 1.0E-4);
                double ij2 = (i - j) * (i - j);
                _homogeneity += 2.0 * value / (1.0 + ij2);
                _contrast += 2.0 * value * ij2;
                ++i;
                ++offset;
            }
            offset += j + 2;
            diagOffset += 257;
        }
        descriptors.put(angularSecondMoment, _angularSecondMoment);
        descriptors.put(contrast, _contrast);
        descriptors.put(entropy, -_entropy);
        descriptors.put(homogeneity, _homogeneity);
        return descriptors;
    }

    private static IcyBufferedImage buildGLCM(IcyBufferedImage image, ROI2D roi, int step) {
        IcyBufferedImage imByte = null;
        if (image.getDataType_() == DataType.UBYTE) {
            imByte = image;
        } else {
            image.updateChannelsBounds();
            imByte = IcyBufferedImageUtil.convertToType((IcyBufferedImage)image, (DataType)DataType.UBYTE, (boolean)true, (boolean)false);
        }
        double[] _cooc = new double[65536];
        IcyBufferedImage coocImage = new IcyBufferedImage(256, 256, (Object[])new double[][]{_cooc});
        int imageWidth = imByte.getSizeX();
        int imageHeight = imByte.getSizeY();
        byte[] data = imByte.getDataXYAsByte(0);
        BooleanMask2D mask = roi.getBooleanMask(true);
        int offset = 0;
        for (int y = 0; y < imageHeight; ++y) {
            int x = 0;
            while (x < imageWidth) {
                if (mask.contains(x, y)) {
                    int neighborVal;
                    int val = data[offset] & 0xFF;
                    int val256 = val * 256;
                    if (x - step >= 0 && mask.contains(x - step, y)) {
                        neighborVal = data[offset - step] & 0xFF;
                        int n = val + neighborVal * 256;
                        _cooc[n] = _cooc[n] + 1.0;
                        int n2 = neighborVal + val256;
                        _cooc[n2] = _cooc[n2] + 1.0;
                    }
                    if (y - step >= 0 && mask.contains(x, y - step)) {
                        int offsetAbove = offset - imageWidth;
                        neighborVal = data[offsetAbove] & 0xFF;
                        int n = val + neighborVal * 256;
                        _cooc[n] = _cooc[n] + 1.0;
                        int n3 = neighborVal + val256;
                        _cooc[n3] = _cooc[n3] + 1.0;
                        if (x + step < imageWidth && mask.contains(x + step, y)) {
                            neighborVal = data[offsetAbove + step] & 0xFF;
                            int n4 = val + neighborVal * 256;
                            _cooc[n4] = _cooc[n4] + 1.0;
                            int n5 = neighborVal + val256;
                            _cooc[n5] = _cooc[n5] + 1.0;
                        }
                        if (x - step >= 0 && mask.contains(x - step, y)) {
                            neighborVal = data[offsetAbove - step] & 0xFF;
                            int n6 = val + neighborVal * 256;
                            _cooc[n6] = _cooc[n6] + 1.0;
                            int n7 = neighborVal + val256;
                            _cooc[n7] = _cooc[n7] + 1.0;
                        }
                    }
                }
                ++x;
                ++offset;
            }
        }
        ArrayMath.divide((double[])_cooc, (double)ArrayMath.sum((double[])_cooc), (double[])_cooc);
        return coocImage;
    }

    public String getMainPluginClassName() {
        return ROIMeasures.class.getName();
    }

    public static class ROIHomogeneity
    extends ROIHaralickDescriptor {
        public ROIHomogeneity() {
            super("Texture homogeneity", Double.class);
        }

        public ROIHomogeneity(int step) {
            super("Texture homogeneity", Double.class, step);
        }

        public String getDescription() {
            return "Homogeneity (Haralick texture descriptor)";
        }

        public boolean separateChannel() {
            return true;
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
            if (!(roi instanceof ROI2D)) {
                throw new UnsupportedOperationException("(More than 2)-D ROI are not supported");
            }
            return ROIHaralickTextureDescriptor.computeHaralickFeatures(sequence, (ROI2D)roi, this.step).get(homogeneity);
        }
    }

    public static class ROIEntropy
    extends ROIHaralickDescriptor {
        public ROIEntropy() {
            super("Texture entropy", Double.class);
        }

        public ROIEntropy(int step) {
            super("Texture entropy", Double.class, step);
        }

        public String getDescription() {
            return "Entropy (Haralick texture descriptor)";
        }

        public boolean separateChannel() {
            return true;
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
            if (!(roi instanceof ROI2D)) {
                throw new UnsupportedOperationException("(More than 2)-D ROI are not supported");
            }
            return ROIHaralickTextureDescriptor.computeHaralickFeatures(sequence, (ROI2D)roi, this.step).get(entropy);
        }
    }

    public static class ROIContrast
    extends ROIHaralickDescriptor {
        public ROIContrast() {
            super("Texture contrast", Double.class);
        }

        public ROIContrast(int step) {
            super("Texture contrast", Double.class, step);
        }

        public String getDescription() {
            return "Contrast (Haralick texture descriptor)";
        }

        public boolean separateChannel() {
            return true;
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
            if (!(roi instanceof ROI2D)) {
                throw new UnsupportedOperationException("(More than 2)-D ROI are not supported");
            }
            return ROIHaralickTextureDescriptor.computeHaralickFeatures(sequence, (ROI2D)roi, this.step).get(contrast);
        }
    }

    public static class ROIAngularSecondMoment
    extends ROIHaralickDescriptor {
        public ROIAngularSecondMoment() {
            super("Texture angular second moment", Double.class);
        }

        public ROIAngularSecondMoment(int step) {
            super("Texture angular second moment", Double.class, step);
        }

        public String getDescription() {
            return "Angular Second Moment (Haralick texture descriptor)";
        }

        public boolean separateChannel() {
            return true;
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
            if (!(roi instanceof ROI2D)) {
                throw new UnsupportedOperationException("(More than 2)-D ROI are not supported");
            }
            return ROIHaralickTextureDescriptor.computeHaralickFeatures(sequence, (ROI2D)roi, this.step).get(angularSecondMoment);
        }
    }

    private static abstract class ROIHaralickDescriptor
    extends ROIDescriptor {
        protected final int step;

        protected ROIHaralickDescriptor(String name, Class<?> type) {
            this(name, type, 1);
        }

        protected ROIHaralickDescriptor(String name, Class<?> type, int step) {
            super(name, type);
            this.step = step;
        }
    }
}

