/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import java.io.IOException;
import java.lang.reflect.Method;

public class BrowserLauncher
implements PlugIn {
    private static Class mrjFileUtilsClass;
    private static Method openURL;
    private static boolean error;

    @Override
    public void run(String theURL) {
        if (error) {
            return;
        }
        if (theURL == null || theURL.equals("")) {
            theURL = "http://imagej.nih.gov/ij";
        }
        try {
            BrowserLauncher.openURL(theURL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void openURL(String url) throws IOException {
        String errorMessage = "";
        if (IJ.isMacOSX()) {
            IJ.runMacro("exec('open', getArgument())", url);
        } else {
            if (IJ.isWindows()) {
                String cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                if (System.getProperty("os.name").startsWith("Windows 2000")) {
                    cmd = "rundll32 shell32.dll,ShellExec_RunDLL " + url;
                }
                Process process = Runtime.getRuntime().exec(cmd);
                try {
                    process.waitFor();
                    process.exitValue();
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            String[] browsers = new String[]{"xdg-open", "netscape", "firefox", "konqueror", "mozilla", "opera", "epiphany", "lynx"};
            String browserName = null;
            try {
                for (int count = 0; count < browsers.length && browserName == null; ++count) {
                    String[] c = new String[]{"which", browsers[count]};
                    if (Runtime.getRuntime().exec(c).waitFor() != 0) continue;
                    browserName = browsers[count];
                }
                if (browserName == null) {
                    IJ.error("BrowserLauncher", "Could not find a browser");
                } else {
                    Runtime.getRuntime().exec(new String[]{browserName, url});
                }
            }
            catch (Exception e) {
                throw new IOException("Exception while launching browser: " + e.getMessage());
            }
        }
    }
}

