/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.regionGrowing;

import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.distanceMap3d.EDT;
import mcib3d.image3d.regionGrowing.Watershed3D;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.Logger.AbstractLog;
import mcib3d.utils.Logger.IJLog;

public class Watershed3DVoronoi {
    private ImageInt seeds = null;
    private float radiusMax = Float.MAX_VALUE;
    private ImageFloat EDTImage = null;
    private ImageInt watershed = null;
    private ImageInt voronoi = null;
    private boolean labelSeeds = true;
    private AbstractLog log = new IJLog();

    public Watershed3DVoronoi(ImageInt seeds) {
        this.seeds = seeds;
    }

    public Watershed3DVoronoi(ImageInt seeds, float radiusMax) {
        this.seeds = seeds;
        if (!Float.isNaN(radiusMax)) {
            this.radiusMax = radiusMax;
        }
    }

    public void setSeeds(ImageInt seeds) {
        this.seeds = seeds;
        this.EDTImage = null;
        this.watershed = null;
    }

    public void setRadiusMax(float radiusMax) {
        if (!Float.isNaN(radiusMax)) {
            this.radiusMax = radiusMax;
            this.voronoi = null;
        }
    }

    public void setLabelSeeds(boolean labelSeeds) {
        this.labelSeeds = labelSeeds;
    }

    private void computeEDT(boolean show) {
        this.log.log("Computing EDT");
        float resXY = (float)this.seeds.getScaleXY();
        float resZ = (float)this.seeds.getScaleZ();
        this.EDTImage = EDT.run(this.seeds, 0.0f, resXY, resZ, true, 0);
        if (show) {
            this.EDTImage.show("EDT");
        }
    }

    private void computeWatershed(boolean show) {
        if (this.EDTImage == null) {
            this.computeEDT(show);
        }
        this.log.log("Computing Watershed");
        ImageFloat EDTcopy = this.EDTImage.duplicate();
        double max = EDTcopy.getMax();
        EDTcopy.invert();
        EDTcopy.addValue((float)max + 1.0f);
        Watershed3D water = new Watershed3D(EDTcopy, this.seeds, 0, 0);
        water.setLabelSeeds(this.labelSeeds);
        this.watershed = water.getWatershedImage3D();
        this.watershed.replacePixelsValue((int)this.watershed.getMax(), 2);
    }

    private void computeVoronoi(boolean show) {
        if (this.watershed == null) {
            this.computeWatershed(show);
        }
        this.log.log("Computing Voronoi");
        ImageByte mask = this.EDTImage.threshold(this.radiusMax, true, true);
        this.voronoi = this.watershed.duplicate();
        this.voronoi.intersectMask(mask);
    }

    public ImageInt getVoronoiZones(boolean show) {
        if (this.voronoi == null) {
            this.computeVoronoi(show);
        }
        return this.voronoi;
    }

    public ImageInt getVoronoiLines(boolean show) {
        if (this.voronoi == null) {
            this.computeVoronoi(show);
        }
        this.log.log("Computing voronoi lines");
        ImageByte lines = new ImageByte("VoronoiLines", this.voronoi.sizeX, this.voronoi.sizeY, this.voronoi.sizeZ);
        for (int z = 0; z < this.voronoi.sizeZ; ++z) {
            for (int x = 0; x < this.voronoi.sizeX; ++x) {
                for (int y = 0; y < this.voronoi.sizeY; ++y) {
                    if (this.voronoi.getPixel(x, y, z) > 1.0f) {
                        int max1;
                        ArrayUtil tab = this.voronoi.getNeighborhood3x3x3(x, y, z);
                        int max2 = (int)tab.getMaximumBelow(max1 = (int)tab.getMaximumAbove(1.0)[0]);
                        if (max2 <= 1) continue;
                        lines.setPixel(x, y, z, 255);
                        continue;
                    }
                    if (this.voronoi.getPixel(x, y, z) != 1.0f) continue;
                    lines.setPixel(x, y, z, 255);
                }
            }
        }
        return lines;
    }

    public void setLog(AbstractLog logger) {
        this.log = logger;
    }
}

