/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.projection;

import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bioimageanalysis.icy.image.projection.ProjectionAxis;
import org.bioimageanalysis.icy.image.projection.ProjectionCalculator;
import org.bioimageanalysis.icy.image.projection.ProjectionOperationType;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;

public class Projection
extends EzPlug
implements Block,
EzStoppable {
    private EzVarSequence input;
    private EzVarEnum<ProjectionDirection> projectionDir;
    private EzVarEnum<ProjectionType> projectionType;
    private EzVarBoolean restrictToROI;
    private VarSequence output;
    private Sequence inputSequence;
    private ProjectionAxis axis;
    private ProjectionOperationType op;
    private List<ROI> rois;
    private Sequence resultSequence;

    protected void initialize() {
        this.initCommonVars();
        this.restrictToROI.setToolTipText("Check this option to project only the intensity data contained within the sequence ROI");
        this.addEzComponent((EzComponent)this.input);
        this.addEzComponent((EzComponent)this.projectionDir);
        this.addEzComponent((EzComponent)this.projectionType);
        this.addEzComponent((EzComponent)this.restrictToROI);
    }

    public void declareInput(VarList inputMap) {
        this.initCommonVars();
        inputMap.add("input", (Var)this.input.getVariable());
        inputMap.add("projection direction", this.projectionDir.getVariable());
        inputMap.add("projection type", this.projectionType.getVariable());
        inputMap.add("restrict to ROI", this.restrictToROI.getVariable());
    }

    private void initCommonVars() {
        this.input = new EzVarSequence("Input");
        this.projectionDir = new EzVarEnum("Project along", (Enum[])ProjectionDirection.values(), (Enum)ProjectionDirection.Z);
        this.projectionType = new EzVarEnum("Projection type", (Enum[])ProjectionType.values(), (Enum)ProjectionType.MAX);
        this.restrictToROI = new EzVarBoolean("Restrict to ROI", false);
        this.setTimeDisplay(true);
    }

    public void declareOutput(VarList outputMap) {
        this.output = new VarSequence("projected sequence", null);
        outputMap.add("projection output", (Var)this.output);
    }

    protected void execute() {
        if (!this.isHeadLess()) {
            this.getUI().setProgressBarVisible(true);
            this.getUI().setProgressBarValue(Double.NaN);
        }
        this.readInput();
        try {
            this.computeCalculator();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IcyHandledException("Error while projecting: " + e.getMessage(), (Throwable)e);
        }
        this.setOutput();
        this.internalClean();
    }

    private void readInput() {
        this.inputSequence = (Sequence)this.input.getValue(true);
        this.axis = Projection.getAxis((ProjectionDirection)((Object)this.projectionDir.getValue(true)));
        this.op = Projection.getOperation((ProjectionType)((Object)this.projectionType.getValue(true)));
        this.rois = (Boolean)this.restrictToROI.getValue(true) != false ? this.inputSequence.getROIs() : Collections.emptyList();
    }

    private static ProjectionAxis getAxis(ProjectionDirection direction) {
        switch (direction) {
            case X: {
                return ProjectionAxis.X;
            }
            case Y: {
                return ProjectionAxis.Y;
            }
            case C: {
                return ProjectionAxis.C;
            }
            case Z: {
                return ProjectionAxis.Z;
            }
            case T: {
                return ProjectionAxis.T;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)direction));
    }

    private static ProjectionOperationType getOperation(ProjectionType type) {
        switch (type) {
            case MAX: {
                return ProjectionOperationType.MAX;
            }
            case MEAN: {
                return ProjectionOperationType.MEAN;
            }
            case MED: {
                return ProjectionOperationType.MED;
            }
            case MIN: {
                return ProjectionOperationType.MIN;
            }
            case SATSUM: {
                return ProjectionOperationType.SATSUM;
            }
            case STD: {
                return ProjectionOperationType.STD;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)type));
    }

    private void computeCalculator() throws Exception {
        ProjectionCalculator calculator = new ProjectionCalculator.Builder(this.inputSequence).axis(this.axis).operation(this.op).addRois(this.rois).build();
        if (!this.isHeadLess()) {
            calculator.addProgressListener(this::onProgress);
        }
        this.resultSequence = calculator.call();
    }

    private void onProgress(double progress, String message) {
        this.getUI().setProgressBarValue(progress);
        this.getUI().setProgressBarMessage(message);
    }

    private void setOutput() {
        if (this.isHeadLess()) {
            this.output.setValue(this.resultSequence);
        } else {
            this.addSequence(this.resultSequence);
        }
    }

    private void internalClean() {
        this.getUI().setProgressBarVisible(false);
        this.inputSequence = null;
        this.axis = null;
        this.op = null;
        this.rois = null;
        this.resultSequence = null;
    }

    public void clean() {
    }

    public static Sequence zProjection(Sequence in, ProjectionType projection) throws Exception {
        return Projection.zProjection(in, projection, true, false);
    }

    public static Sequence zProjection(Sequence in, ProjectionType projection, boolean multiThread) throws Exception {
        return Projection.zProjection(in, projection, multiThread, false);
    }

    public static Sequence zProjection(Sequence in, ProjectionType projection, boolean multiThread, boolean restrictToROI) throws Exception {
        ArrayList rois = restrictToROI ? in.getROIs() : Collections.emptyList();
        ProjectionCalculator calculator = new ProjectionCalculator.Builder(in).axis(ProjectionAxis.Z).operation(Projection.getOperation(projection)).addRois(rois).build();
        return calculator.call();
    }

    public static Sequence tProjection(Sequence in, ProjectionType projection, boolean multiThread) throws Exception {
        return Projection.tProjection(in, projection, multiThread, false);
    }

    public static Sequence tProjection(Sequence in, ProjectionType projection, boolean multiThread, boolean restrictToROI) throws Exception {
        ArrayList rois = restrictToROI ? in.getROIs() : Collections.emptyList();
        ProjectionCalculator calculator = new ProjectionCalculator.Builder(in).axis(ProjectionAxis.T).operation(Projection.getOperation(projection)).addRois(rois).build();
        return calculator.call();
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)Projection.class.getName()));
    }

    public static enum ProjectionType {
        MAX("Maximum"),
        MEAN("Average"),
        MED("Median"),
        MIN("Minimum"),
        STD("Standard Deviation"),
        SATSUM("Saturated Sum");

        private final String description;

        private ProjectionType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum ProjectionDirection {
        Z,
        T,
        C,
        Y,
        X;

    }
}

