/*
 * Copyright (C) 2002-2009  Patrick Pirrotte, Jerome Mutterer, Yannick Krempp
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *	This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
import ij.*;
import ij.io.*;
import ij.plugin.PlugIn;
import ij.process.LUT;

import org.imagearchive.lsm.reader.Reader;

public class LSM_Reader extends ImagePlus implements PlugIn {

	public static final String VERSION = "4.0h";

	public final String infoMessage = "LSM_Reader "
			+ VERSION
			+ " Copyright (C) 2002-2009 P. Pirrotte, J. Mutterer, Y. Krempp\n\n"
			+ "LSM_Reader is a lightweight cutdown version of LSMToolbox which\n"
			+ "is available at imagejdocu.tudor.lu or www.image-archive.org\n"
			+ "and offers many more features. This software is subject to the\n"
			+ "GNU General Public License. Please read source code headers\n\n"
			+ "Works on images generated by LSM 510 version 2.8 to 4.0, Zen 2009\n"
			+ "Contacts :\n\npatrick@image-archive.org\n"
			+ "jerome.mutterer@ibmp.fr\n";

	public void run(String arg) {
		if (arg.equals("about")) {
			showAbout();
			return;
		}
		if (IJ.versionLessThan("1.46"))
            return;
		OpenDialog od = new OpenDialog("Open LSM...", arg);
		String directory = od.getDirectory();
		String name = od.getFileName();
		if (name==null) return;
		IJ.showStatus("Opening: " + directory + name);
		ImagePlus imp = new Reader().open(directory+name);
		if (imp==null) return;
		setStack(imp.getTitle(), imp.getStack());
		FileInfo fi = imp.getOriginalFileInfo();
		if (imp.isComposite())
			new FileSaver(imp).saveDisplayRangesAndLuts(imp, fi);
		setFileInfo(fi);
		setCalibration(imp.getCalibration());
		setDimensions(imp.getNChannels(), imp.getNSlices(), imp.getNFrames());
		if (imp.getNChannels()*imp.getNFrames()!=1)
			setOpenAsHyperStack(true);
		if (arg.equals("")) show();
	}

	public void showAbout() {
		IJ.showMessage(infoMessage);
	}

	public ImagePlus open(String filename, boolean verbose) {
		return new Reader().open(filename, verbose);
	}

	public ImagePlus open(String directory, String filename, boolean verbose,
			boolean thumb) {
		return new Reader().open(directory, filename, verbose, thumb);
	}
	
}
