/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.importer;

import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.sequence.SequenceIdImporter;
import java.awt.Rectangle;
import ome.xml.meta.OMEXMLMetadata;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;
import plugins.tprovoost.sequenceblocks.importer.PositionedSequenceFileImporter;

public class SequenceFileImporterLoadSequence
extends Plugin
implements IOBlock,
PluginLibrary,
PluginBundled {
    protected final Var<PositionedSequenceFileImporter> importer = new Var("Importer", PositionedSequenceFileImporter.class);
    protected final VarInteger series = new VarInteger("Series", -1);
    protected final VarInteger resolution = new VarInteger("Resolution (0=full, 1=1/2, ..)", 0);
    protected final VarROIArray region = new VarROIArray("XY region (ROI)", null);
    protected final VarInteger minZIndex = new VarInteger("Z min (slice)", -1);
    protected final VarInteger maxZIndex = new VarInteger("Z max (slice)", -1);
    protected final VarInteger minTIndex = new VarInteger("T min (frame)", -1);
    protected final VarInteger maxTIndex = new VarInteger("T max (frame)", -1);
    protected final VarInteger cIndex = new VarInteger("C (channel) index", -1);
    protected final VarSequence sequence = new VarSequence("Sequence", null);

    public void run() {
        Rectangle rect;
        PositionedSequenceFileImporter pi = (PositionedSequenceFileImporter)this.importer.getValue();
        if (pi == null) {
            throw new VarException(this.importer, "Importer is null !");
        }
        SequenceFileImporter imp = pi.importer;
        if (imp.getOpened() == null) {
            throw new VarException(this.importer, "Importer is not opened !");
        }
        int res = this.resolution.getValue();
        ROI[] rois = (ROI[])this.region.getValue();
        int s = this.series.getValue();
        int minZ = this.minZIndex.getValue();
        int maxZ = this.maxZIndex.getValue();
        int minT = this.minTIndex.getValue();
        int maxT = this.maxTIndex.getValue();
        int c = this.cIndex.getValue();
        Rectangle rectangle = rect = rois != null && rois.length > 0 ? rois[0].getBounds5D().toRectangle2D().getBounds() : null;
        if (s == -1 && pi.s != -1) {
            s = pi.s;
        }
        if (minZ == -1 && maxZ == -1 && pi.z != -1) {
            minZ = pi.z;
            maxZ = pi.z;
        }
        if (minT == -1 && maxT == -1 && pi.t != -1) {
            minT = pi.t;
            maxT = pi.t;
        }
        if (c == -1 && pi.c != -1) {
            c = pi.c;
        }
        if (rect == null && pi.xyRegion != null) {
            rect = pi.xyRegion;
        }
        if (s == -1) {
            s = 0;
        }
        try {
            OMEXMLMetadata meta = pi.getMetadata();
            this.sequence.setValue(Loader.internalLoadSingle((SequenceIdImporter)imp, (OMEXMLMetadata)meta, (int)s, (int)res, (Rectangle)rect, (int)minZ, (int)maxZ, (int)minT, (int)maxT, (int)c, (boolean)false, null));
        }
        catch (Exception e) {
            throw new VarException(this.importer, e.getMessage());
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("importer", this.importer);
        inputMap.add("series", (Var)this.series);
        inputMap.add("resolution", (Var)this.resolution);
        inputMap.add("region", (Var)this.region);
        inputMap.add("minZ", (Var)this.minZIndex);
        inputMap.add("maxZ", (Var)this.maxZIndex);
        inputMap.add("minT", (Var)this.minTIndex);
        inputMap.add("maxT", (Var)this.maxTIndex);
        inputMap.add("cIndex", (Var)this.cIndex);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("sequence", (Var)this.sequence);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }
}

