/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.importer;

import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.util.ClassUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.model.ValueSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;
import plugins.tprovoost.sequenceblocks.importer.PositionedSequenceFileImporter;

public class SequenceFileImporterOpen
extends Plugin
implements IOBlock,
PluginLibrary,
PluginBundled {
    static final String ID_AUTO = "Automatic";
    protected final VarString importerName;
    protected final Var<PositionedSequenceFileImporter> importer;
    protected final VarMutable file;
    protected final VarInteger flag;
    protected final Map<String, SequenceFileImporter> importersMap;

    public SequenceFileImporterOpen() {
        ArrayList<String> importersName = new ArrayList<String>();
        List importers = Loader.getSequenceFileImporters();
        this.importerName = new VarString("Select importer", "", 1 + importers.size());
        this.importersMap = new HashMap<String, SequenceFileImporter>();
        importersName.add(ID_AUTO);
        this.importersMap.put(ID_AUTO, null);
        for (SequenceFileImporter importer : importers) {
            String className = ClassUtil.getBaseClassName((String)importer.getClass().getName());
            int ind = className.lastIndexOf(46);
            if (ind > -1) {
                className = className.substring(ind + 1, className.length());
            }
            importersName.add(className);
            this.importersMap.put(className, importer);
        }
        this.importerName.setDefaultEditorModel((VarEditorModel)new ValueSelectionModel((Object[])importersName.toArray(new String[importersName.size()]), importersName.get(0), false));
        this.importer = new Var("Importer", PositionedSequenceFileImporter.class);
        this.file = new VarMutable("File", null){

            public boolean isAssignableFrom(Var source) {
                return String.class == source.getType() || File.class == source.getType();
            }
        };
        this.flag = new VarInteger("Flag", 0);
    }

    public void run() {
        String path;
        Object obj = this.file.getValue();
        if (obj != null) {
            path = obj instanceof String ? (String)obj : ((File)obj).getAbsolutePath();
        } else {
            throw new VarException((Var)this.file, "File is null !");
        }
        SequenceFileImporter imp = this.importersMap.get(this.importerName.getValue());
        if (imp == null) {
            imp = Loader.getSequenceFileImporter((String)path, (boolean)true);
        }
        if (imp == null) {
            throw new VarException(this.importer, "Cannot find an importer for file: '" + path + "' !");
        }
        this.importer.setValue((Object)new PositionedSequenceFileImporter(imp));
        try {
            imp.open(path, this.flag.getValue().intValue());
        }
        catch (Exception e) {
            throw new VarException(this.importer, e.getMessage());
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("name", (Var)this.importerName);
        inputMap.add("file", (Var)this.file);
        inputMap.add("flag", (Var)this.flag);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("importer", this.importer);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }
}

