/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.loop;

import icy.file.SequenceFileImporter;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import java.util.List;
import plugins.adufour.blocks.lang.Batch;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;
import plugins.tprovoost.sequenceblocks.importer.PositionedSequenceFileImporter;

public abstract class SequenceFileImporterBatch
extends Batch
implements SequenceBlock,
PluginLibrary,
PluginBundled {
    protected Var<PositionedSequenceFileImporter> positionedImporter;
    protected Var<PositionedSequenceFileImporter> element;
    protected VarInteger series;
    protected int limit;

    public Var<PositionedSequenceFileImporter> getBatchSource() {
        if (this.positionedImporter == null) {
            this.positionedImporter = new Var("Importer", PositionedSequenceFileImporter.class);
        }
        return this.positionedImporter;
    }

    public Var<PositionedSequenceFileImporter> getBatchElement() {
        if (this.element == null) {
            this.element = new Var("Loop importer", PositionedSequenceFileImporter.class);
        }
        return this.element;
    }

    public void initializeLoop() {
        PositionedSequenceFileImporter value = (PositionedSequenceFileImporter)this.positionedImporter.getValue();
        if (value == null) {
            throw new VarException(this.positionedImporter, "Input importer is null !");
        }
        SequenceFileImporter imp = value.importer;
        if (imp.getOpened() == null) {
            throw new VarException(this.positionedImporter, "Importer is not opened !");
        }
        PositionedSequenceFileImporter pi = new PositionedSequenceFileImporter(value);
        int s = this.series.getValue();
        if (s != -1) {
            pi.s = s;
        }
        this.element.setValue((Object)pi);
    }

    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        if (this.series == null) {
            this.series = new VarInteger("Series", -1);
        }
        inputMap.add("series", (Var)this.series);
    }

    public void declareLoopVariables(List<Var<?>> loopVariables) {
        super.declareLoopVariables(loopVariables);
        if (this.series == null) {
            this.series = new VarInteger("Series", -1);
        }
        loopVariables.add((Var<?>)this.series);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }
}

