/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.loop;

import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import java.util.List;
import plugins.adufour.blocks.lang.Batch;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

public class SequenceRegionBatch
extends Batch
implements SequenceBlock,
PluginLibrary,
PluginBundled {
    protected VarSequence inputSequence;
    protected VarSequence element;
    protected VarROIArray rois;
    protected VarROIArray currentRoi;

    public VarROIArray getBatchSource() {
        if (this.rois == null) {
            this.rois = new VarROIArray("ROI(s)");
        }
        return this.rois;
    }

    public VarSequence getBatchElement() {
        if (this.element == null) {
            this.element = new VarSequence("Region Sequence", null);
        }
        return this.element;
    }

    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        if (this.inputSequence == null) {
            this.inputSequence = new VarSequence("Sequence", null);
        }
        inputMap.add(this.inputSequence.getName(), (Var)this.inputSequence);
    }

    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        if (this.currentRoi == null) {
            this.currentRoi = new VarROIArray("Current ROI");
        }
        outputMap.add(this.currentRoi.getName(), (Var)this.currentRoi);
    }

    public void initializeLoop() {
        Sequence value = (Sequence)this.inputSequence.getValue();
        if (value == null) {
            throw new VarException((Var)this.inputSequence, "No input sequence indicated");
        }
        if (this.rois.getValue() == null) {
            throw new VarException((Var)this.rois, "No roi(s) indicated --> no region to iterate over");
        }
    }

    public void beforeIteration() {
        ROI roi = ((ROI[])this.rois.getValue())[this.getIterationCounter().getValue()];
        this.element.setValue(SequenceUtil.getSubSequence((Sequence)((Sequence)this.inputSequence.getValue()), (ROI)roi));
        this.currentRoi.setValue((Object)new ROI[]{roi});
    }

    public boolean isStopConditionReached() {
        return this.getIterationCounter().getValue() >= ((ROI[])this.rois.getValue()).length;
    }

    public void declareLoopVariables(List<Var<?>> loopVariables) {
        super.declareLoopVariables(loopVariables);
        loopVariables.add((Var<?>)this.inputSequence);
        loopVariables.add((Var<?>)this.currentRoi);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }
}

