/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.convert;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.lut.LUT;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import icy.util.OMEUtil;
import java.awt.image.BufferedImage;
import ome.xml.meta.MetadataRetrieve;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

public class ConvertColor
extends Plugin
implements SequenceBlock,
PluginBundled {
    protected final VarSequence EZseq = new VarSequence("Sequence", null);
    protected final VarEnum<ColorConversion> EZtype = new VarEnum("Conversion", (Enum)ColorConversion.ARGB);
    protected final Var<LUT> EZlut = new Var("Lut", LUT.class);
    protected final VarSequence varOut = new VarSequence("Out", null);

    public void run() {
        Sequence s = (Sequence)this.EZseq.getValue();
        if (s == null) {
            throw new VarException((Var)this.EZseq, "Input sequence is null.");
        }
        this.varOut.setValue(ConvertColor.convertColor(s, ConvertColor.getImageType((ColorConversion)((Object)this.EZtype.getValue())), (LUT)this.EZlut.getValue()));
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Sequence", (Var)this.EZseq);
        inputMap.add("Conversion", this.EZtype);
        inputMap.add("Lut", this.EZlut);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("Out", (Var)this.varOut);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }

    public static int getImageType(ColorConversion value) {
        switch (value) {
            default: {
                return 2;
            }
            case RGB: {
                return 1;
            }
            case GRAY: 
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Sequence convertColor(Sequence source, int imageType, LUT lut) {
        Sequence result = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata()));
        BufferedImage imgOut = new BufferedImage(source.getSizeX(), source.getSizeY(), imageType);
        result.beginUpdate();
        try {
            for (int t = 0; t < source.getSizeT(); ++t) {
                for (int z = 0; z < source.getSizeZ(); ++z) {
                    result.setImage(t, z, IcyBufferedImageUtil.toBufferedImage((IcyBufferedImage)source.getImage(t, z), (BufferedImage)imgOut, (LUT)lut));
                }
            }
            switch (imageType) {
                default: {
                    result.setChannelName(0, "red");
                    result.setChannelName(1, "green");
                    result.setChannelName(2, "blue");
                    result.setChannelName(3, "alpha");
                    result.setName(source.getName() + " (ARGB rendering)");
                    return result;
                }
                case 1: {
                    result.setChannelName(0, "red");
                    result.setChannelName(1, "green");
                    result.setChannelName(2, "blue");
                    result.setName(source.getName() + " (RGB rendering)");
                    return result;
                }
                case 10: {
                    result.setChannelName(0, "gray");
                    result.setName(source.getName() + " (gray rendering)");
                    return result;
                }
            }
        }
        finally {
            result.endUpdate();
        }
    }

    public static enum ColorConversion {
        GRAY,
        RGB,
        ARGB;

    }
}

