/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.extract;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.collection.CollectionUtil;
import icy.util.ShapeUtil;
import java.util.ArrayList;
import java.util.List;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarSequence;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

public class CropSequence
extends Plugin
implements SequenceBlock,
PluginLibrary,
PluginBundled {
    protected final VarSequence inputSequence = new VarSequence("Sequence", null);
    VarMutable inputROIs = new VarMutable("ROI(s)", null){

        public boolean isAssignableFrom(Var source) {
            return ROI.class == source.getType() || ROI[].class == source.getType();
        }
    };
    protected final VarSequence outputSequence = new VarSequence("Cropped", null);

    public void run() {
        List<Object> rois;
        this.outputSequence.setValue(null);
        Sequence s = (Sequence)this.inputSequence.getValue();
        if (s == null) {
            return;
        }
        Object obj = this.inputROIs.getValue();
        if (obj == null) {
            return;
        }
        if (obj instanceof ROI) {
            rois = new ArrayList<ROI>();
            rois.add((ROI)obj);
        } else {
            rois = CollectionUtil.asList((Object[])((ROI[])obj));
        }
        ROI roi = ROIUtil.merge(rois, (ShapeUtil.BooleanOperator)ShapeUtil.BooleanOperator.OR);
        this.outputSequence.setValue(SequenceUtil.getSubSequence((Sequence)s, (ROI)roi));
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("sequence", (Var)this.inputSequence);
        inputMap.add("roi", (Var)this.inputROIs);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("cropped", (Var)this.outputSequence);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }
}

