/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.files;

import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import java.awt.Rectangle;
import java.io.File;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

public class LoadSubSequence
extends Plugin
implements IOBlock,
PluginLibrary,
PluginBundled {
    protected final Var<SequenceFileImporter> importer = new Var("Importer", SequenceFileImporter.class);
    protected final VarMutable file = new VarMutable("File", null){

        public boolean isAssignableFrom(Var source) {
            return String.class == source.getType() || File.class == source.getType();
        }
    };
    protected final VarInteger series = new VarInteger("Series", 0);
    protected final VarInteger resolution = new VarInteger("Resolution (0=full, 1=1/2, ..)", 0);
    protected final VarROIArray region = new VarROIArray("XY region (ROI)", null);
    protected final VarInteger minZIndex = new VarInteger("Z min (slice)", -1);
    protected final VarInteger maxZIndex = new VarInteger("Z max (slice)", -1);
    protected final VarInteger minTIndex = new VarInteger("T min (frame)", -1);
    protected final VarInteger maxTIndex = new VarInteger("T max (frame)", -1);
    protected final VarInteger cIndex = new VarInteger("C (channel) index", -1);
    protected final VarBoolean showProgress = new VarBoolean("Show progress", Boolean.FALSE);
    protected final VarSequence sequence = new VarSequence("Sequence", null);

    public void run() {
        String path;
        Object obj = this.file.getValue();
        if (obj != null) {
            path = obj instanceof String ? (String)obj : ((File)obj).getAbsolutePath();
        } else {
            throw new VarException((Var)this.file, "File is null !");
        }
        SequenceFileImporter imp = (SequenceFileImporter)this.importer.getValue();
        int s = this.series.getValue();
        int r = this.resolution.getValue();
        ROI[] rois = (ROI[])this.region.getValue();
        ROI roi = rois != null && rois.length > 0 ? rois[0] : null;
        int minZ = this.minZIndex.getValue();
        int maxZ = this.maxZIndex.getValue();
        int minT = this.minTIndex.getValue();
        int maxT = this.maxTIndex.getValue();
        int c = this.cIndex.getValue();
        boolean progress = (Boolean)this.showProgress.getValue();
        try {
            this.sequence.setValue(Loader.loadSequence((SequenceFileImporter)imp, (String)path, (int)s, (int)r, (Rectangle)(roi != null ? roi.getBounds5D().toRectangle2D().getBounds() : null), (int)minZ, (int)maxZ, (int)minT, (int)maxT, (int)c, (boolean)false, (boolean)progress));
        }
        catch (Exception e) {
            throw new VarException(this.importer, e.getMessage());
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("file", (Var)this.file);
        inputMap.add("importer", this.importer);
        inputMap.add("series", (Var)this.series);
        inputMap.add("resolution", (Var)this.resolution);
        inputMap.add("region", (Var)this.region);
        inputMap.add("minZ", (Var)this.minZIndex);
        inputMap.add("maxZ", (Var)this.maxZIndex);
        inputMap.add("minT", (Var)this.minTIndex);
        inputMap.add("maxT", (Var)this.maxTIndex);
        inputMap.add("cIndex", (Var)this.cIndex);
        inputMap.add("showProgress", (Var)this.showProgress);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("sequence", (Var)this.sequence);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }
}

