/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.importer;

import icy.file.SequenceFileImporter;
import icy.image.IcyBufferedImage;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import java.awt.Rectangle;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;
import plugins.tprovoost.sequenceblocks.importer.PositionedSequenceFileImporter;

public class SequenceFileImporterGetImage
extends Plugin
implements IOBlock,
PluginLibrary,
PluginBundled {
    protected final Var<PositionedSequenceFileImporter> importer = new Var("Importer", PositionedSequenceFileImporter.class);
    protected final VarInteger series = new VarInteger("Series", -1);
    protected final VarInteger resolution = new VarInteger("Resolution (0=full, 1=1/2, ..)", 0);
    protected final VarROIArray region = new VarROIArray("XY region (ROI)", null);
    protected final VarInteger zIndex = new VarInteger("Z (slice) index", -1);
    protected final VarInteger tIndex = new VarInteger("T (frame) index", -1);
    protected final VarInteger cIndex = new VarInteger("C (channel) index", -1);
    protected final Var<IcyBufferedImage> image = new Var("Image", IcyBufferedImage.class);

    public void run() {
        Rectangle rect;
        PositionedSequenceFileImporter pi = (PositionedSequenceFileImporter)this.importer.getValue();
        if (pi == null) {
            throw new VarException(this.importer, "Importer is null !");
        }
        SequenceFileImporter imp = pi.importer;
        if (imp.getOpened() == null) {
            throw new VarException(this.importer, "Importer is not opened !");
        }
        int res = this.resolution.getValue();
        ROI[] rois = (ROI[])this.region.getValue();
        int s = this.series.getValue();
        int z = this.zIndex.getValue();
        int t = this.tIndex.getValue();
        int c = this.cIndex.getValue();
        Rectangle rectangle = rect = rois != null && rois.length > 0 ? rois[0].getBounds5D().toRectangle2D().getBounds() : null;
        if (s == -1 && pi.s != -1) {
            s = pi.s;
        }
        if (z == -1 && pi.z != -1) {
            z = pi.z;
        }
        if (t == -1 && pi.t != -1) {
            t = pi.t;
        }
        if (c == -1 && pi.c != -1) {
            c = pi.c;
        }
        if (rect == null && pi.xyRegion != null) {
            rect = pi.xyRegion;
        }
        if (s == -1) {
            s = 0;
        }
        try {
            this.image.setValue((Object)imp.getImage(s, res, rect, z, t, c));
        }
        catch (Exception e) {
            throw new VarException(this.importer, e.getMessage());
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("importer", this.importer);
        inputMap.add("series", (Var)this.series);
        inputMap.add("resolution", (Var)this.resolution);
        inputMap.add("region", (Var)this.region);
        inputMap.add("zIndex", (Var)this.zIndex);
        inputMap.add("tIndex", (Var)this.tIndex);
        inputMap.add("cIndex", (Var)this.cIndex);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("image", this.image);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }
}

