/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.loop;

import icy.file.SequenceFileImporter;
import icy.image.ImageUtil;
import icy.sequence.MetaDataUtil;
import java.awt.Rectangle;
import java.util.List;
import ome.xml.meta.OMEXMLMetadata;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.importer.PositionedSequenceFileImporter;
import plugins.tprovoost.sequenceblocks.loop.SequenceFileImporterBatch;

public class SequenceFileImporterTileBatch
extends SequenceFileImporterBatch {
    protected VarInteger tileW;
    protected VarInteger tileH;
    protected List<Rectangle> tiles;

    @Override
    public void initializeLoop() {
        super.initializeLoop();
        PositionedSequenceFileImporter pi = (PositionedSequenceFileImporter)this.element.getValue();
        if (pi.xyRegion == null) {
            int th;
            int tw;
            int sizeY;
            int sizeX;
            SequenceFileImporter imp = pi.importer;
            int s = pi.s == -1 ? 0 : pi.s;
            try {
                sizeX = MetaDataUtil.getSizeX((OMEXMLMetadata)pi.getMetadata(), (int)s);
                sizeY = MetaDataUtil.getSizeY((OMEXMLMetadata)pi.getMetadata(), (int)s);
                tw = this.tileW.getValue();
                th = this.tileH.getValue();
                if (tw == -1) {
                    tw = imp.getTileWidth(s);
                }
                if (th == -1) {
                    th = imp.getTileHeight(s);
                }
            }
            catch (Exception e) {
                throw new VarException(this.element, "Error while initializing SequenceFileImporter tile batch: " + e.getMessage());
            }
            if (tw == -1) {
                tw = 1024;
            } else if (tw == 0) {
                tw = sizeX;
            }
            if (th == -1) {
                th = 1024;
            } else if (th == 0) {
                th = sizeY;
            }
            this.tiles = ImageUtil.getTileList((int)sizeX, (int)sizeY, (int)tw, (int)th);
            this.limit = this.tiles.size();
        } else {
            this.limit = 1;
        }
    }

    @Override
    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        if (this.tileW == null) {
            this.tileW = new VarInteger("Tile width (-1 = auto)", -1);
        }
        if (this.tileH == null) {
            this.tileH = new VarInteger("Tile height (-1 = auto)", -1);
        }
        inputMap.add("tileWidht", (Var)this.tileW);
        inputMap.add("tileHeight", (Var)this.tileH);
    }

    @Override
    public void declareLoopVariables(List<Var<?>> loopVariables) {
        super.declareLoopVariables(loopVariables);
        if (this.tileW == null) {
            this.tileW = new VarInteger("Tile width (-1 = auto)", -1);
        }
        if (this.tileH == null) {
            this.tileH = new VarInteger("Tile height (-1 = auto)", -1);
        }
        loopVariables.add((Var<?>)this.tileW);
        loopVariables.add((Var<?>)this.tileH);
    }

    public void beforeIteration() {
        if (((PositionedSequenceFileImporter)this.positionedImporter.getValue()).xyRegion == null) {
            ((PositionedSequenceFileImporter)this.element.getValue()).xyRegion = this.tiles.get(this.getIterationCounter().getValue());
            this.element.valueChanged(this.element, this.element.getValue(), this.element.getValue());
        }
    }

    public boolean isStopConditionReached() {
        return this.getIterationCounter().getValue() >= this.limit;
    }
}

