/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.convert;

import icy.image.IcyBufferedImageUtil;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

public class Resize
extends Plugin
implements SequenceBlock,
PluginBundled {
    protected final VarSequence EZseq = new VarSequence("Sequence", null);
    protected final VarInteger EZsizew = new VarInteger("Width", 320);
    protected final VarInteger EZsizeh = new VarInteger("Height", 200);
    protected final VarEnum<Proportional> EZproportional = new VarEnum("Proportional", (Enum)Proportional.NO);
    protected final VarBoolean EZscale = new VarBoolean("Scale content", Boolean.TRUE);
    protected final VarEnum<IcyBufferedImageUtil.FilterType> EZtype = new VarEnum("Filter", (Enum)IcyBufferedImageUtil.FilterType.BICUBIC);
    protected final VarSequence varOut = new VarSequence("Out", null);

    public void run() {
        Sequence s = (Sequence)this.EZseq.getValue();
        int w = this.EZsizew.getValue();
        int h = this.EZsizeh.getValue();
        IcyBufferedImageUtil.FilterType type = (IcyBufferedImageUtil.FilterType)this.EZtype.getValue();
        if (s == null || w <= 0 || h <= 0) {
            throw new VarException(null, "No sequence chosen for resize, or wrong size.");
        }
        double scale = 1.0 * (double)s.getWidth() / (double)s.getHeight();
        switch ((Proportional)((Object)this.EZproportional.getValue())) {
            case NO: {
                break;
            }
            case TO_WIDTH: {
                h = (int)((double)w / scale);
                break;
            }
            case TO_HEIGHT: {
                w = (int)(scale * (double)h);
            }
        }
        if (((Boolean)this.EZscale.getValue()).booleanValue()) {
            this.varOut.setValue(SequenceUtil.scale((Sequence)s, (int)w, (int)h, (IcyBufferedImageUtil.FilterType)type));
        } else {
            this.varOut.setValue(SequenceUtil.scale((Sequence)s, (int)w, (int)h, (boolean)false, (int)0, (int)0, (IcyBufferedImageUtil.FilterType)type));
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Sequence", (Var)this.EZseq);
        inputMap.add("Width", (Var)this.EZsizew);
        inputMap.add("Height", (Var)this.EZsizeh);
        inputMap.add("Proportional", this.EZproportional);
        inputMap.add("Filter", this.EZtype);
        inputMap.add("Scale content", (Var)this.EZscale);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("Out", (Var)this.varOut);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }

    protected static enum Proportional {
        NO,
        TO_WIDTH,
        TO_HEIGHT;

    }
}

