/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.importer;

import icy.file.SequenceFileImporter;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.sequence.MetaDataUtil;
import ome.xml.meta.OMEXMLMetadata;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;
import plugins.tprovoost.sequenceblocks.importer.PositionedSequenceFileImporter;

public class SequenceFileImporterGetMetadata
extends Plugin
implements IOBlock,
PluginLibrary,
PluginBundled {
    protected final Var<PositionedSequenceFileImporter> importer = new Var("Importer", PositionedSequenceFileImporter.class);
    protected final Var<OMEXMLMetadata> metadata = new Var("Metadata", OMEXMLMetadata.class);
    protected final VarInteger numSeries = new VarInteger("Series number", 1);

    public void run() {
        PositionedSequenceFileImporter pi = (PositionedSequenceFileImporter)this.importer.getValue();
        if (pi == null) {
            throw new VarException(this.importer, "Importer is null !");
        }
        SequenceFileImporter imp = pi.importer;
        if (imp.getOpened() == null) {
            throw new VarException(this.importer, "Importer is not opened !");
        }
        try {
            OMEXMLMetadata meta = imp.getOMEXMLMetaData();
            this.metadata.setValue((Object)meta);
            if (meta != null) {
                this.numSeries.setValue((Object)MetaDataUtil.getNumSeries((OMEXMLMetadata)meta));
            }
        }
        catch (Exception e) {
            throw new VarException(this.importer, e.getMessage());
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("importer", this.importer);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("metadata", this.metadata);
        outputMap.add("numSerie", (Var)this.numSeries);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }
}

