/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.infos;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

public class GetRoisAsRegion
extends Plugin
implements SequenceBlock,
PluginLibrary,
PluginBundled {
    protected final VarSequence inputSequence = new VarSequence("Sequence", null);
    protected final VarEnum<TypeSelection> type = new VarEnum("ROI(s) to get", (Enum)TypeSelection.ALL);
    protected final VarBoolean originResolution = new VarBoolean("Origin resolution", Boolean.TRUE);
    protected final VarROIArray regionsRois = new VarROIArray("Region ROI(s)", null);

    public void run() {
        ArrayList rois;
        Sequence sequence = (Sequence)this.inputSequence.getValue();
        if (sequence == null) {
            throw new VarException((Var)this.inputSequence, "Input sequence is null.");
        }
        ArrayList<ROI2DRectangle> result = new ArrayList<ROI2DRectangle>();
        switch ((TypeSelection)((Object)this.type.getValue())) {
            default: {
                rois = sequence.getROIs();
                break;
            }
            case SELECTED: {
                rois = sequence.getSelectedROIs();
            }
        }
        boolean scale = (Boolean)this.originResolution.getValue();
        for (ROI roi : rois) {
            Rectangle rect = roi.getBounds5D().toRectangle2D().getBounds();
            if (scale) {
                rect = SequenceUtil.getOriginRectangle((Rectangle)rect, (Sequence)sequence);
            }
            result.add(new ROI2DRectangle((Rectangle2D)rect));
        }
        this.regionsRois.setValue((Object)result.toArray(new ROI[result.size()]));
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("sequence", (Var)this.inputSequence);
        inputMap.add("type", this.type);
        inputMap.add("originResolution", (Var)this.originResolution);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("regionsRois", (Var)this.regionsRois);
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }

    public static enum TypeSelection {
        ALL,
        SELECTED;

    }
}

