/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.loop;

import icy.roi.ROI;
import icy.sequence.MetaDataUtil;
import icy.type.rectangle.Rectangle2DUtil;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import ome.xml.meta.OMEXMLMetadata;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.importer.PositionedSequenceFileImporter;
import plugins.tprovoost.sequenceblocks.loop.SequenceFileImporterBatch;

public class SequenceFileImporterRegionBatch
extends SequenceFileImporterBatch {
    protected VarROIArray rois;
    protected VarInteger inputRoisResolution;
    protected VarInteger inputRoisMargin;
    protected List<Rectangle> regions;

    @Override
    public void initializeLoop() {
        super.initializeLoop();
        PositionedSequenceFileImporter pi = (PositionedSequenceFileImporter)this.element.getValue();
        if (pi.xyRegion == null && this.rois.getValue() != null) {
            Rectangle regionMask;
            int s = pi.s == -1 ? 0 : pi.s;
            try {
                regionMask = new Rectangle(0, 0, MetaDataUtil.getSizeX((OMEXMLMetadata)pi.getMetadata(), (int)s), MetaDataUtil.getSizeY((OMEXMLMetadata)pi.getMetadata(), (int)s));
            }
            catch (Exception e) {
                throw new VarException(this.element, "Error while initializing SequenceFileImporter region batch: " + e.getMessage());
            }
            double scaleFactor = Math.pow(2.0, this.inputRoisResolution.getValue().doubleValue());
            double margeFactor = 1.0 + this.inputRoisMargin.getValue().doubleValue() / 100.0;
            this.regions = new ArrayList<Rectangle>();
            for (ROI roi : (ROI[])this.rois.getValue()) {
                Rectangle2D region = roi.getBounds5D().toRectangle2D();
                if (scaleFactor != 1.0) {
                    region = Rectangle2DUtil.getScaledRectangle((Rectangle2D)region, (double)scaleFactor, (boolean)false, (boolean)true);
                }
                if (margeFactor != 1.0) {
                    region = Rectangle2DUtil.getScaledRectangle((Rectangle2D)region, (double)margeFactor, (boolean)true, (boolean)false);
                }
                this.regions.add(region.getBounds().intersection(regionMask));
            }
            this.limit = this.regions.size();
        } else {
            this.limit = 1;
        }
    }

    public void beforeIteration() {
        if (((PositionedSequenceFileImporter)this.positionedImporter.getValue()).xyRegion == null) {
            ((PositionedSequenceFileImporter)this.element.getValue()).xyRegion = this.regions.get(this.getIterationCounter().getValue());
            this.element.valueChanged(this.element, this.element.getValue(), this.element.getValue());
        }
    }

    @Override
    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        if (this.rois == null) {
            this.rois = new VarROIArray("XY regions (ROIs)");
        }
        if (this.inputRoisResolution == null) {
            this.inputRoisResolution = new VarInteger("ROIs resolution", 0);
        }
        if (this.inputRoisMargin == null) {
            this.inputRoisMargin = new VarInteger("ROIs margin", 20);
        }
        inputMap.add("regions", (Var)this.rois);
        inputMap.add("inputResolution", (Var)this.inputRoisResolution);
        inputMap.add("inputRoisMarge", (Var)this.inputRoisMargin);
    }

    @Override
    public void declareLoopVariables(List<Var<?>> loopVariables) {
        super.declareLoopVariables(loopVariables);
        if (this.rois == null) {
            this.rois = new VarROIArray("XY regions (ROIs)");
        }
        if (this.inputRoisResolution == null) {
            this.inputRoisResolution = new VarInteger("ROIs resolution", 0);
        }
        if (this.inputRoisMargin == null) {
            this.inputRoisMargin = new VarInteger("ROIs margin", 20);
        }
        loopVariables.add((Var<?>)this.rois);
        loopVariables.add((Var<?>)this.inputRoisResolution);
        loopVariables.add((Var<?>)this.inputRoisMargin);
    }

    public boolean isStopConditionReached() {
        return this.getIterationCounter().getValue() >= this.limit;
    }
}

