/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.sequenceblocks.op;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.type.DataIterator;
import icy.type.DataIteratorUtil;
import icy.type.collection.CollectionUtil;
import icy.type.rectangle.Rectangle5D;
import icy.util.ShapeUtil;
import java.util.List;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.kernel.roi.roi5d.ROI5DStackRectangle;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

public class FillOuterSequence
extends Plugin
implements SequenceBlock,
PluginLibrary,
PluginBundled {
    protected final VarSequence inputSequence = new VarSequence("Sequence", null);
    protected final VarROIArray rois = new VarROIArray("Roi(s)");
    protected final VarDouble fillValue = new VarDouble("Value", 0.0);

    public void run() {
        Sequence sequence = (Sequence)this.inputSequence.getValue();
        if (sequence == null) {
            throw new VarException((Var)this.inputSequence, "Input sequence is null.");
        }
        if (this.rois.getValue() != null) {
            try {
                ROI roiUnion = ROIUtil.merge((List)CollectionUtil.asList((Object[])((Object[])this.rois.getValue())), (ShapeUtil.BooleanOperator)ShapeUtil.BooleanOperator.OR);
                ROI5DStackRectangle roiSeq = new ROI5DStackRectangle((Rectangle5D)sequence.getBounds5D());
                ROI roi = roiSeq.getSubtraction(roiUnion);
                double value = this.fillValue.getValue();
                DataIteratorUtil.set((DataIterator)new SequenceDataIterator(sequence, roi), (double)value);
                sequence.dataChanged();
            }
            catch (UnsupportedOperationException e) {
                throw new VarException((Var)this.rois, e.getMessage());
            }
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("sequence", (Var)this.inputSequence);
        inputMap.add("rois", (Var)this.rois);
        inputMap.add("value", (Var)this.fillValue);
    }

    public void declareOutput(VarList outputMap) {
    }

    public String getMainPluginClassName() {
        return SequenceBlocks.class.getName();
    }
}

