/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.morphology;

import icy.plugin.abstract_.PluginActionable;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class FillHolesInROI
extends PluginActionable
implements ROIBlock {
    private boolean blockMode = false;
    private VarROIArray roiIN = new VarROIArray("List of ROI");
    private VarROIArray roiOUT = new VarROIArray("List of hole-filled ROI");

    public void declareInput(VarList inputMap) {
        this.blockMode = true;
        inputMap.add("List of ROI", (Var)this.roiIN);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("List of hole-filled ROI", (Var)this.roiOUT);
    }

    public void run() {
        this.roiOUT.setValue((Object)new ROI[0]);
        Sequence sequence = null;
        ArrayList rois = null;
        if (this.blockMode) {
            rois = Arrays.asList((Object[])this.roiIN.getValue());
        } else {
            sequence = this.getActiveSequence();
            if (sequence == null) {
                throw new IcyHandledException("Fill holes in ROI: please open an image first.");
            }
            rois = sequence.getROIs();
        }
        for (ROI roi : rois) {
            ROI2DArea newROI;
            boolean change;
            if (roi instanceof ROI2D) {
                ROI2D roiIN = (ROI2D)(this.blockMode ? roi.getCopy() : roi);
                BooleanMask2D mask = roiIN.getBooleanMask(true);
                change = FillHolesInROI.fillHoles(mask);
                if (this.blockMode) {
                    if (!change) {
                        this.roiOUT.add((Object[])new ROI[]{roiIN});
                    } else {
                        newROI = new ROI2DArea(mask);
                        newROI.setC(roiIN.getC());
                        newROI.setZ(roiIN.getZ());
                        newROI.setT(roiIN.getT());
                        this.roiOUT.add((Object[])new ROI[]{newROI});
                    }
                } else if (change) {
                    newROI = new ROI2DArea(mask);
                    newROI.setC(roiIN.getC());
                    newROI.setZ(roiIN.getZ());
                    newROI.setT(roiIN.getT());
                    newROI.setSelected(roi.isSelected());
                    sequence.addROI((ROI)newROI);
                    sequence.removeROI(roi);
                }
            }
            if (roi instanceof ROI3D) {
                ROI3D roi3d = (ROI3D)(this.blockMode ? roi.getCopy() : roi);
                BooleanMask3D mask3d = roi3d.getBooleanMask(true);
                change = FillHolesInROI.fillHoles(mask3d);
                if (this.blockMode) {
                    if (!change) {
                        this.roiOUT.add((Object[])new ROI[]{roi3d});
                        continue;
                    }
                    newROI = new ROI3DArea(mask3d);
                    newROI.setC(roi3d.getC());
                    newROI.setT(roi3d.getT());
                    this.roiOUT.add((Object[])new ROI[]{newROI});
                    continue;
                }
                if (!change) continue;
                newROI = new ROI3DArea(mask3d);
                newROI.setC(roi3d.getC());
                newROI.setT(roi3d.getT());
                newROI.setSelected(roi.isSelected());
                sequence.addROI((ROI)newROI);
                sequence.removeROI(roi);
                continue;
            }
            if (!this.blockMode) continue;
            this.roiOUT.add((Object[])new ROI[]{roi});
        }
    }

    public static Path2D fillPath(PathIterator path, VarBoolean pathChanged) {
        if (pathChanged != null) {
            pathChanged.setValue((Object)false);
        }
        Path2D.Double filledPath = new Path2D.Double();
        boolean isPathEmpty = true;
        double[] coords = new double[6];
        ArrayList segments = new ArrayList();
        ArrayList<Point2D.Double> currentSegment = null;
        Path2D currentPath = null;
        while (!path.isDone()) {
            int segment = path.currentSegment(coords);
            switch (segment) {
                case 0: {
                    currentSegment = new ArrayList<Point2D.Double>();
                    segments.add(currentSegment);
                    currentSegment.add(new Point2D.Double(coords[0], coords[1]));
                    currentPath = new Path2D.Double();
                    currentPath.moveTo(coords[0], coords[1]);
                    break;
                }
                case 4: {
                    currentPath.closePath();
                    System.out.print(currentSegment.size() + " points: algebraic area is ");
                    int nm1 = currentSegment.size() - 1;
                    double area = 0.0;
                    for (int i = 0; i < nm1; ++i) {
                        Point2D.Double p1 = (Point2D.Double)currentSegment.get(i);
                        Point2D.Double p2 = (Point2D.Double)currentSegment.get(i + 1);
                        area += (p2.x * p1.y - p1.x * p2.y) * 0.5;
                    }
                    Point2D.Double p1 = (Point2D.Double)currentSegment.get(nm1);
                    Point2D.Double p2 = (Point2D.Double)currentSegment.get(0);
                    System.out.println((area += (p2.x * p1.y - p1.x * p2.y) * 0.5) > 0.0 ? "positive, keeping" : "negative, discarding");
                    if (area > 0.0) {
                        filledPath.append(currentPath, false);
                        isPathEmpty = false;
                        break;
                    }
                    if (pathChanged == null) break;
                    pathChanged.setValue((Object)true);
                    break;
                }
                case 3: {
                    currentSegment.add(new Point2D.Double(coords[4], coords[5]));
                    currentPath.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    currentSegment.add(new Point2D.Double(coords[0], coords[1]));
                    currentPath.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    currentSegment.add(new Point2D.Double(coords[2], coords[3]));
                    currentPath.quadTo(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            path.next();
        }
        return isPathEmpty ? null : filledPath;
    }

    public static boolean fillHoles(BooleanMask2D mask) {
        int neighbor;
        int width = mask.bounds.width;
        int height = mask.bounds.height;
        if (width == 1 || height == 1) {
            return false;
        }
        int slice = width * height;
        boolean[] isObject = mask.mask;
        byte[] labels = new byte[slice];
        byte UNKNOWN = 0;
        byte TO_VISIT = 1;
        byte BACKGROUND = 2;
        int[] pixelOffsetsToVisit = new int[slice];
        int n = 0;
        int top = 0;
        int bottom = slice - width;
        while (top < width) {
            if (!isObject[top]) {
                labels[top] = BACKGROUND;
                neighbor = top + width;
                if (labels[neighbor] == UNKNOWN) {
                    pixelOffsetsToVisit[n++] = neighbor;
                    labels[neighbor] = TO_VISIT;
                }
            }
            if (!isObject[bottom]) {
                labels[bottom] = BACKGROUND;
                neighbor = bottom - width;
                if (labels[neighbor] == UNKNOWN) {
                    pixelOffsetsToVisit[n++] = neighbor;
                    labels[neighbor] = TO_VISIT;
                }
            }
            ++top;
            ++bottom;
        }
        int left = width;
        int right = 2 * width - 1;
        while (left < slice - width) {
            if (!isObject[left]) {
                labels[left] = BACKGROUND;
                neighbor = left + 1;
                if (labels[neighbor] == UNKNOWN) {
                    pixelOffsetsToVisit[n++] = neighbor;
                    labels[neighbor] = TO_VISIT;
                }
            }
            if (!isObject[right]) {
                labels[right] = BACKGROUND;
                neighbor = right - 1;
                if (labels[neighbor] == UNKNOWN) {
                    pixelOffsetsToVisit[n++] = neighbor;
                    labels[neighbor] = TO_VISIT;
                }
            }
            left += width;
            right += width;
        }
        if (n > 0) {
            int[] neighbors = new int[4];
            for (int index = 0; index < n; ++index) {
                int offset = pixelOffsetsToVisit[index];
                if (labels[offset] == BACKGROUND || isObject[offset]) continue;
                labels[offset] = BACKGROUND;
                neighbors[0] = offset - 1;
                neighbors[1] = offset + 1;
                neighbors[2] = offset - width;
                neighbors[3] = offset + width;
                for (int neighbor2 : neighbors) {
                    if (labels[neighbor2] != UNKNOWN || isObject[neighbor2]) continue;
                    pixelOffsetsToVisit[n++] = neighbor2;
                    labels[neighbor2] = TO_VISIT;
                }
            }
        }
        boolean change = false;
        for (int i = 0; i < slice; ++i) {
            if (labels[i] != UNKNOWN || isObject[i]) continue;
            isObject[i] = true;
            change = true;
        }
        return change;
    }

    private static boolean fillHoles(BooleanMask3D mask3d) {
        boolean change = false;
        int slice = mask3d.bounds.z;
        for (int k = 0; k < mask3d.bounds.sizeZ; ++k) {
            BooleanMask2D mask2d = mask3d.getMask2D(slice);
            change = FillHolesInROI.fillHoles(mask2d) || change;
            ++slice;
        }
        return change;
    }
}

