/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.tensorflow.versionmanager.loading;

import org.bioimageanalysis.icy.tensorflow.versionmanager.version.TensorFlowVersion;

public class LibraryLoadingStatus {
    public static final String LOADED = "Loaded";
    public static final String ALREADY_LOADED = "Already loaded";
    public static final String NOT_LOADED = "Not loaded";
    public static final String ERROR_LOADING = "Error loading";
    private String status;
    private TensorFlowVersion targetVersion;
    private TensorFlowVersion loadedVersion;
    private String message;

    public static LibraryLoadingStatus loaded(TensorFlowVersion targetVersion) {
        return new LibraryLoadingStatus(LOADED, targetVersion, targetVersion);
    }

    public static LibraryLoadingStatus alreadyLoaded(TensorFlowVersion targetVersion, TensorFlowVersion loadedVersion) {
        return new LibraryLoadingStatus(ALREADY_LOADED, targetVersion, loadedVersion);
    }

    public static LibraryLoadingStatus notLoaded() {
        return new LibraryLoadingStatus(NOT_LOADED, null, null);
    }

    public static LibraryLoadingStatus errorLoading(TensorFlowVersion targetVersion, TensorFlowVersion loadedVersion, String errorMessage) {
        return new LibraryLoadingStatus(ERROR_LOADING, targetVersion, loadedVersion, errorMessage);
    }

    public LibraryLoadingStatus(String status, TensorFlowVersion targetVersion, TensorFlowVersion loadedVersion, String message) {
        this.status = status;
        this.targetVersion = targetVersion;
        this.loadedVersion = loadedVersion;
        this.message = message;
    }

    public LibraryLoadingStatus(String status, TensorFlowVersion targetVersion, TensorFlowVersion loadedVersion) {
        this(status, targetVersion, loadedVersion, "");
    }

    public String getStatus() {
        return this.status;
    }

    public TensorFlowVersion getTargetVersion() {
        return this.targetVersion;
    }

    public TensorFlowVersion getLoadedVersion() {
        return this.loadedVersion;
    }

    public String getMessage() {
        return this.message;
    }
}

