/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.tensorflowmanager;

import icy.file.FileUtil;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginLibrary;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import org.bioimageanalysis.icy.tensorflow.versionmanager.loading.LibraryLoadingStatus;
import org.bioimageanalysis.icy.tensorflow.versionmanager.loading.TensorFlowVersionDownloader;
import org.bioimageanalysis.icy.tensorflow.versionmanager.version.TensorFlowVersion;

public class TensorFlowManager
extends Plugin
implements PluginLibrary {
    private static boolean libraryLoaded = false;
    private static TensorFlowVersion loadedVersion = null;

    public static boolean isLibraryLoaded() {
        if (libraryLoaded) {
            return true;
        }
        if (PluginLoader.isLoaded((String)"org.tensorflow.TensorFlow")) {
            try {
                Class cl = PluginLoader.loadClass((String)"org.tensorflow.TensorFlow");
                Method method = cl.getMethod("version", new Class[0]);
                method.invoke((Object)cl, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public static TensorFlowVersion getLoadedVersion() {
        return loadedVersion;
    }

    public static synchronized LibraryLoadingStatus loadLibrary(TensorFlowVersion targetVersion, boolean forceDownload) throws IOException {
        Objects.requireNonNull(targetVersion, "Null TensorFlow version");
        if (!TensorFlowManager.isLibraryLoaded()) {
            try {
                List<Path> libraryArtifacts = !TensorFlowVersionDownloader.isDownloaded(targetVersion) || forceDownload ? TensorFlowVersionDownloader.download(targetVersion) : TensorFlowVersionDownloader.getDownloadedFilePaths(targetVersion);
                TensorFlowManager.loadLibraryToPluginLoader(targetVersion, libraryArtifacts);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return LibraryLoadingStatus.loaded(targetVersion);
        }
        if (Objects.equals(TensorFlowManager.getLoadedVersion(), targetVersion)) {
            return LibraryLoadingStatus.alreadyLoaded(targetVersion, TensorFlowManager.getLoadedVersion());
        }
        String message = "(loaded: " + (TensorFlowManager.getLoadedVersion() == null ? "Unknown" : TensorFlowManager.getLoadedVersion().getVersion() + "-" + TensorFlowManager.getLoadedVersion().getOs() + "-" + TensorFlowManager.getLoadedVersion().getMode()) + ", target: " + (targetVersion == null ? "Unknown" : targetVersion.getVersion() + "-" + targetVersion.getOs() + "-" + targetVersion.getMode()) + ")";
        throw new IOException("Tried loading a different TensorFlow version " + message);
    }

    private static void loadLibraryToPluginLoader(TensorFlowVersion targetVersion, List<Path> libraryArtifacts) throws IOException {
        Path pluginPath = Paths.get(".", "plugins", "danyfel80", "tensorflowmanager");
        Path libJarsPath = pluginPath.resolve("tensorflowlibs");
        FileUtil.delete((String)libJarsPath.toString(), (boolean)true);
        Files.createDirectories(libJarsPath, new FileAttribute[0]);
        for (Path downloadPath : libraryArtifacts) {
            Path targetPath = libJarsPath.resolve(downloadPath.getFileName());
            System.out.println("copying: " + targetPath);
            Files.copy(downloadPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        PluginLoader.reload();
        try {
            Class cl = PluginLoader.loadClass((String)"org.tensorflow.TensorFlow");
            System.out.println("Loaded library for " + cl.getSimpleName() + "-" + cl.getMethod("version", new Class[0]).invoke((Object)cl, new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        loadedVersion = targetVersion;
        libraryLoaded = true;
    }
}

