/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.tensorflowmanager;

import icy.gui.dialog.MessageDialog;
import icy.preferences.XMLPreferences;
import icy.system.IcyHandledException;
import icy.util.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.tensorflow.versionmanager.loading.LibraryLoadingStatus;
import org.bioimageanalysis.icy.tensorflow.versionmanager.version.AvailableTensorFlowVersions;
import org.bioimageanalysis.icy.tensorflow.versionmanager.version.TensorFlowVersion;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarString;
import plugins.danyfel80.tensorflowmanager.TensorFlowManager;

public class TensorFlowVersionSelector
extends EzPlug
implements EzStoppable,
Block {
    private EzVarText varInVersion;
    private static final Map<String, TensorFlowVersion> versions = AvailableTensorFlowVersions.loadCompatibleOnly().getVersions().stream().collect(Collectors.toMap(v -> "API " + v.getVersion() + "-" + v.getMode() + " for TF " + v.getTensorFlowVersion(), Function.identity()));
    private VarString varInBlockVersion;
    VarBoolean varOutLoaded;

    protected void initialize() {
        String[] versionStrings = (String[])versions.keySet().stream().sorted().toArray(String[]::new);
        this.varInVersion = new EzVarText("Version", versionStrings, this.getDefaultVersionIndex(versionStrings), Boolean.valueOf(false));
        this.addEzComponent((EzComponent)this.varInVersion);
    }

    public void declareInput(VarList inputMap) {
        String lastUsedVersion = this.getLastUsedVersion();
        lastUsedVersion = !lastUsedVersion.equals("") ? lastUsedVersion : versions.keySet().stream().findFirst().orElse("");
        this.varInBlockVersion = new VarString("Library version", lastUsedVersion);
    }

    public void declareOutput(VarList outputMap) {
        this.varOutLoaded = new VarBoolean("Loaded", false);
        outputMap.add("Loaded", (Var)this.varOutLoaded);
    }

    private int getDefaultVersionIndex(String[] versionStrings) {
        String lastUsedVersion = this.getLastUsedVersion();
        int lastIndex = 0;
        if (versions.containsKey(lastUsedVersion)) {
            for (int i = 0; i < versionStrings.length; ++i) {
                if (!versionStrings[i].equals(lastUsedVersion)) continue;
                lastIndex = i;
                break;
            }
        }
        return lastIndex;
    }

    private String getLastUsedVersion() {
        XMLPreferences prefs = this.getPreferencesRoot();
        return prefs.get("lastUsed", "");
    }

    protected void execute() {
        String targetVersion = !this.isHeadLess() ? (String)this.varInVersion.getValue(true) : (String)this.varInBlockVersion.getValue(true);
        TensorFlowVersion version = versions.get(targetVersion);
        try {
            this.notifyProgress(Double.NaN, "Loading TensorFlow " + version.getVersion() + "-" + version.getOs() + "-" + version.getMode() + "...");
            LibraryLoadingStatus status = TensorFlowManager.loadLibrary(version, false);
            if (status.getStatus().equals("Error loading")) {
                this.notifyError("Error loading TensorFlow: " + status.getMessage());
            } else {
                this.notifyInfo("Loaded: version=" + version.getVersion() + ", mode=" + version.getMode() + ", for TF version=" + version.getTensorFlowVersion());
            }
            if (!this.isHeadLess()) {
                this.getUI().close();
            } else {
                this.varOutLoaded.setValue((Object)true);
            }
        }
        catch (IOException e) {
            this.varOutLoaded.setValue((Object)false);
            e.printStackTrace();
            throw new IcyHandledException("Could not load TensorFlow library: ", (Throwable)e);
        }
    }

    private void notifyProgress(double progress, String message) {
        if (this.isHeadLess()) {
            System.out.println("(" + StringUtil.toString((double)(Double.isFinite(progress) ? progress * 100.0 : 0.0), (int)2) + "%)" + message);
        } else {
            this.getUI().setProgressBarValue(progress);
            this.getUI().setProgressBarMessage(message);
        }
    }

    private void notifyError(String message) {
        if (this.isHeadLess()) {
            System.err.println(message);
        } else {
            MessageDialog.showDialog((String)"Error", (String)message, (int)0);
        }
    }

    private void notifyInfo(String message) {
        if (this.isHeadLess()) {
            System.out.println(message);
        } else {
            MessageDialog.showDialog((String)"Success", (String)message, (int)1);
        }
    }

    public void clean() {
    }
}

