/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.tensorflow.versionmanager.loading;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.tensorflow.versionmanager.version.TensorFlowVersion;

public class TensorFlowVersionDownloader {
    private static Path downloadsPath = Paths.get(".", "downloads").toAbsolutePath();

    public static boolean isDownloaded(TensorFlowVersion targetVersion) {
        boolean directoryExists;
        Path versionDirectory = TensorFlowVersionDownloader.getVersionDirectoryPath(targetVersion);
        boolean bl = directoryExists = Files.exists(versionDirectory, new LinkOption[0]) && Files.isDirectory(versionDirectory, new LinkOption[0]);
        if (directoryExists) {
            for (String jarUrl : targetVersion.getJars()) {
                Path localPath;
                try {
                    localPath = TensorFlowVersionDownloader.toLocalVersionFile(versionDirectory, jarUrl);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return false;
                }
                if (!Files.notExists(localPath, new LinkOption[0])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Path getVersionDirectoryPath(TensorFlowVersion targetVersion) {
        return downloadsPath.resolve("tensorflow-" + targetVersion.getVersion() + "-" + targetVersion.getOs() + "-" + targetVersion.getMode()).toAbsolutePath();
    }

    private static Path toLocalVersionFile(Path versionDirectory, String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        Path fileName = Paths.get(url.getPath(), new String[0]).getFileName();
        return versionDirectory.resolve(fileName);
    }

    public static List<Path> download(TensorFlowVersion targetVersion) throws IOException {
        Path versionDirectory = TensorFlowVersionDownloader.getVersionDirectoryPath(targetVersion);
        if (Files.notExists(versionDirectory, new LinkOption[0])) {
            Files.createDirectories(versionDirectory, new FileAttribute[0]);
        }
        ForkJoinPool pool = new ForkJoinPool();
        Future resultList = pool.submit(() -> {
            AtomicInteger downloadedFiles = new AtomicInteger();
            int totalFiles = targetVersion.getJars().size();
            return targetVersion.getJars().parallelStream().map(urlString -> {
                try {
                    Path resultPath = TensorFlowVersionDownloader.downloadFile(urlString, versionDirectory);
                    System.out.println("(" + downloadedFiles.incrementAndGet() + "/" + totalFiles + ") File downloaded to: " + resultPath.toString());
                    return resultPath;
                }
                catch (IOException e) {
                    System.out.println("(" + downloadedFiles.incrementAndGet() + "/" + totalFiles + ") File failed downloading: " + urlString);
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        });
        try {
            return (List)resultList.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    private static Path downloadFile(String urlString, Path versionDirectory) throws IOException {
        URL url = new URL(urlString);
        Path localFilePath = TensorFlowVersionDownloader.toLocalVersionFile(versionDirectory, urlString);
        Files.deleteIfExists(localFilePath);
        ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
        FileOutputStream fileOutputStream = new FileOutputStream(localFilePath.toString());
        fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        return localFilePath;
    }

    public static List<Path> getDownloadedFilePaths(TensorFlowVersion targetVersion) {
        Path versionDirectory = TensorFlowVersionDownloader.getVersionDirectoryPath(targetVersion);
        List<Path> pathList = targetVersion.getJars().stream().map(urlString -> {
            try {
                return TensorFlowVersionDownloader.toLocalVersionFile(versionDirectory, urlString);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return pathList;
    }
}

