/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.tensorflow.versionmanager.version;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.system.PlatformDetection;
import org.bioimageanalysis.icy.tensorflow.versionmanager.version.TensorFlowVersion;

public class AvailableTensorFlowVersions {
    private List<TensorFlowVersion> versions;

    public static AvailableTensorFlowVersions loadCompatibleOnly() {
        AvailableTensorFlowVersions availableVersions = AvailableTensorFlowVersions.load();
        String currentPlatform = new PlatformDetection().toString();
        availableVersions.setVersions(availableVersions.getVersions().stream().filter(v -> v.getOs().equals(currentPlatform)).collect(Collectors.toList()));
        return availableVersions;
    }

    public static AvailableTensorFlowVersions load() {
        BufferedReader br = new BufferedReader(new InputStreamReader(AvailableTensorFlowVersions.class.getClassLoader().getResourceAsStream("availableTFVersions.json")));
        Gson g = new Gson();
        AvailableTensorFlowVersions availableVersions = (AvailableTensorFlowVersions)g.fromJson((Reader)br, AvailableTensorFlowVersions.class);
        return availableVersions;
    }

    public List<TensorFlowVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<TensorFlowVersion> versions) {
        this.versions = versions;
    }
}

