/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.islic;

public class CIELab {
    private static final double[] whitePoint = new double[]{95.0429, 100.0, 108.89};

    public static double[] fromRGB(int[] rgb) {
        return CIELab.fromXYZ(XYZ.fromRGB(rgb));
    }

    public static double[] fromRGB(int r, int g, int b) {
        return CIELab.fromXYZ(XYZ.fromRGB(r, g, b));
    }

    private static double[] fromXYZ(double[] xyz) {
        return CIELab.fromXYZ(xyz[0], xyz[1], xyz[2]);
    }

    public static double[] fromXYZ(double X, double Y, double Z) {
        double x = X / whitePoint[0];
        double y = Y / whitePoint[1];
        double z = Z / whitePoint[2];
        x = x > 0.008856 ? Math.pow(x, 0.3333333333333333) : 7.787 * x + 0.13793103448275862;
        y = y > 0.008856 ? Math.pow(y, 0.3333333333333333) : 7.787 * y + 0.13793103448275862;
        z = z > 0.008856 ? Math.pow(z, 0.3333333333333333) : 7.787 * z + 0.13793103448275862;
        double[] result = new double[]{116.0 * y - 16.0, 500.0 * (x - y), 200.0 * (y - z)};
        return result;
    }

    public static int[] toRGB(double[] lab) {
        return XYZ.toRGB(CIELab.toXYZ(lab));
    }

    public static int[] toRGB(double L, double a, double b) {
        return XYZ.toRGB(CIELab.toXYZ(L, a, b));
    }

    public static double[] toXYZ(double[] lab) {
        return CIELab.toXYZ(lab[0], lab[1], lab[2]);
    }

    public static double[] toXYZ(double L, double a, double b) {
        double[] result = new double[3];
        double y = (L + 16.0) / 116.0;
        double y3 = Math.pow(y, 3.0);
        double x = a / 500.0 + y;
        double x3 = Math.pow(x, 3.0);
        double z = y - b / 200.0;
        double z3 = Math.pow(z, 3.0);
        y = y3 > 0.008856 ? y3 : (y - 0.13793103448275862) / 7.787;
        x = x3 > 0.008856 ? x3 : (x - 0.13793103448275862) / 7.787;
        z = z3 > 0.008856 ? z3 : (z - 0.13793103448275862) / 7.787;
        result[0] = x * whitePoint[0];
        result[1] = y * whitePoint[1];
        result[2] = z * whitePoint[2];
        return result;
    }

    public static class XYZ {
        private static final double[][] M = new double[][]{{0.4124, 0.3576, 0.1805}, {0.2126, 0.7152, 0.0722}, {0.0193, 0.1192, 0.9505}};
        private static final double[][] Mi = new double[][]{{3.2406, -1.5372, -0.4986}, {-0.9689, 1.8758, 0.0415}, {0.0557, -0.204, 1.057}};

        public static double[] fromRGB(int[] rgb) {
            return XYZ.fromRGB(rgb[0], rgb[1], rgb[2]);
        }

        public static double[] fromRGB(int R, int G, int B) {
            double[] result = new double[3];
            double r = (double)R / 255.0;
            double g = (double)G / 255.0;
            double b = (double)B / 255.0;
            r = r <= 0.04045 ? (r /= 12.92) : Math.pow((r + 0.055) / 1.055, 2.4);
            g = g <= 0.04045 ? (g /= 12.92) : Math.pow((g + 0.055) / 1.055, 2.4);
            b = b <= 0.04045 ? (b /= 12.92) : Math.pow((b + 0.055) / 1.055, 2.4);
            result[0] = (r *= 100.0) * M[0][0] + (g *= 100.0) * M[0][1] + (b *= 100.0) * M[0][2];
            result[1] = r * M[1][0] + g * M[1][1] + b * M[1][2];
            result[2] = r * M[2][0] + g * M[2][1] + b * M[2][2];
            return result;
        }

        public static int[] toRGB(double[] xyz) {
            return XYZ.toRGB(xyz[0], xyz[1], xyz[2]);
        }

        public static int[] toRGB(double X, double Y, double Z) {
            int[] result = new int[3];
            double x = X / 100.0;
            double y = Y / 100.0;
            double z = Z / 100.0;
            double r = x * Mi[0][0] + y * Mi[0][1] + z * Mi[0][2];
            double g = x * Mi[1][0] + y * Mi[1][1] + z * Mi[1][2];
            double b = x * Mi[2][0] + y * Mi[2][1] + z * Mi[2][2];
            r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666666666667) - 0.055 : (r *= 12.92);
            g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.4166666666666667) - 0.055 : (g *= 12.92);
            b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.4166666666666667) - 0.055 : (b *= 12.92);
            r = r < 0.0 ? 0.0 : r;
            g = g < 0.0 ? 0.0 : g;
            b = b < 0.0 ? 0.0 : b;
            result[0] = (int)Math.round(r * 255.0);
            result[1] = (int)Math.round(g * 255.0);
            result[2] = (int)Math.round(b * 255.0);
            return result;
        }
    }
}

