/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.islic;

import algorithms.danyfel80.islic.CIELab;
import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array2DUtil;
import icy.type.point.Point3D;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import plugins.kernel.roi.roi2d.ROI2DArea;

public class SLICTask {
    private static final double EPSILON = 0.25;
    static int MAX_ITERATIONS = 10;
    static double ERROR_THRESHOLD = 0.01;
    private Sequence sequence;
    private int S;
    private int Sx;
    private int Sy;
    private int SPnum;
    private double rigidity;
    private boolean computeROIs;
    private List<ROI> rois;
    private Sequence superPixelsResult;
    private Map<Point3D.Integer, double[]> colorLUT;
    private Map<Point, Double> distanceLUT;

    public SLICTask(Sequence sequence, int SPSize, double rigidity, boolean computeROIs) {
        this.sequence = sequence;
        this.S = SPSize;
        this.Sx = (sequence.getWidth() + this.S / 2 - 1) / this.S;
        this.Sy = (sequence.getHeight() + this.S / 2 - 1) / this.S;
        this.SPnum = this.Sx * this.Sy;
        this.rigidity = rigidity;
        this.computeROIs = computeROIs;
        this.colorLUT = new HashMap<Point3D.Integer, double[]>();
        this.distanceLUT = new HashMap<Point, Double>();
    }

    public void execute() {
        double[] ls = new double[this.SPnum];
        double[] as = new double[this.SPnum];
        double[] bs = new double[this.SPnum];
        double[] cxs = new double[this.SPnum];
        double[] cys = new double[this.SPnum];
        double[][] sequenceData = Array2DUtil.arrayToDoubleArray((Object)this.sequence.getDataXYC(0, 0), (boolean)this.sequence.isSignedDataType());
        this.initialize(ls, as, bs, cxs, cys, sequenceData);
        int[] clusters = new int[this.sequence.getWidth() * this.sequence.getHeight()];
        double[] distances = Arrays.stream(clusters).mapToDouble(i -> Double.MAX_VALUE).toArray();
        int iterations = 0;
        double error = 0.0;
        do {
            this.assignClusters(sequenceData, clusters, distances, ls, as, bs, cxs, cys);
            error = this.updateClusters(sequenceData, clusters, ls, as, bs, cxs, cys);
            System.out.format("Iteration=%d, Error=%f%n", ++iterations, error);
        } while (error > ERROR_THRESHOLD && iterations < MAX_ITERATIONS);
        System.out.format("End of iterations%n", new Object[0]);
        this.computeSuperpixels(sequenceData, clusters, ls, as, bs, cxs, cys);
    }

    private void initialize(double[] ls, double[] as, double[] bs, double[] cxs, double[] cys, double[][] sequenceData) {
        IntStream.range(0, this.SPnum).forEach(sp -> {
            int spx = sp % this.Sx;
            int spy = sp / this.Sx;
            int x = this.S / 2 + spx * this.S;
            int y = this.S / 2 + spy * this.S;
            int yOff = y * this.sequence.getWidth();
            int bestx = x;
            cxs[sp] = bestx;
            int besty = y;
            cys[sp] = besty;
            int bestyOff = yOff;
            double bestGradient = Double.MAX_VALUE;
            for (int j = -1; j <= 1; ++j) {
                if (y + j < 0 || y + j >= this.sequence.getHeight()) continue;
                int yjOff = (y + j) * this.sequence.getWidth();
                for (int i = -1; i <= 1; ++i) {
                    double candidateGradient;
                    if (x < 0 || x >= this.sequence.getWidth() || x + i < 0 || x + i >= this.sequence.getWidth() || !((candidateGradient = this.getGradient(sequenceData, x + yOff, x + i + yjOff)) < bestGradient)) continue;
                    bestx = x + i;
                    besty = y + j;
                    bestyOff = yjOff;
                    bestGradient = candidateGradient;
                }
            }
            cxs[sp] = bestx;
            cys[sp] = besty;
            int bestPos = bestx + bestyOff;
            double[] bestLAB = this.getCIELab(sequenceData, bestPos);
            ls[sp] = bestLAB[0];
            as[sp] = bestLAB[1];
            bs[sp] = bestLAB[2];
        });
    }

    private double getGradient(double[][] data, int pos1, int pos2) {
        int[] valRGB1 = new int[3];
        int[] valRGB2 = new int[3];
        IntStream.range(0, 3).forEach(c -> {
            valRGB1[c] = (int)Math.round(255.0 * (data[c % this.sequence.getSizeC()][pos1] / this.sequence.getDataTypeMax()));
            valRGB2[c] = (int)Math.round(255.0 * (data[c % this.sequence.getSizeC()][pos2] / this.sequence.getDataTypeMax()));
        });
        double[] val1 = CIELab.fromRGB(valRGB1);
        double[] val2 = CIELab.fromRGB(valRGB2);
        double avgGrad = IntStream.range(0, 3).mapToDouble(c -> val2[c] - val1[c]).average().getAsDouble();
        return avgGrad;
    }

    private double[] getCIELab(double[][] sequenceData, int pos) {
        int[] rgbVal = new int[3];
        IntStream.range(0, 3).forEach(c -> {
            rgbVal[c] = (int)Math.round(255.0 * (sequenceData[c % this.sequence.getSizeC()][pos] / this.sequence.getDataTypeMax()));
        });
        Point3D.Integer rgbPoint = new Point3D.Integer(rgbVal);
        double[] LAB = this.colorLUT.get(rgbPoint);
        if (LAB == null) {
            int[] RGB = new int[3];
            IntStream.range(0, 3).forEach(c -> {
                RGB[c] = (int)Math.round(255.0 * (sequenceData[c % this.sequence.getSizeC()][pos] / this.sequence.getDataTypeMax()));
            });
            LAB = CIELab.fromRGB(RGB);
            this.colorLUT.put(rgbPoint, LAB);
        }
        return LAB;
    }

    private void assignClusters(double[][] sequenceData, int[] clusters, double[] distances, double[] ls, double[] as, double[] bs, double[] cxs, double[] cys) {
        IntStream.range(0, this.SPnum).forEach(k -> {
            double ckx = cxs[k];
            double cky = cys[k];
            double lk = ls[k];
            double ak = as[k];
            double bk = bs[k];
            int posk = (int)ckx + (int)cky * this.sequence.getWidth();
            distances[posk] = 0.0;
            clusters[posk] = k;
            for (int j = -this.S; j < this.S; ++j) {
                int ciy = (int)(cky + (double)j);
                if (ciy < 0 || ciy >= this.sequence.getHeight()) continue;
                int yOff = ciy * this.sequence.getWidth();
                for (int i = -this.S; i < this.S; ++i) {
                    double bi;
                    double ai;
                    int posi;
                    double[] LABi;
                    double li;
                    double di;
                    int cix = (int)(ckx + (double)i);
                    if (cix < 0 || cix >= this.sequence.getWidth() || !((di = this.getDistance(ckx, cky, lk, ak, bk, i, j, li = (LABi = this.getCIELab(sequenceData, posi = cix + yOff))[0], ai = LABi[1], bi = LABi[2])) < distances[posi])) continue;
                    distances[posi] = di;
                    clusters[posi] = clusters[posk];
                }
            }
        });
    }

    private double getDistance(double ckx, double cky, double lk, double ak, double bk, int dx, int dy, double li, double ai, double bi) {
        double diffl = li - lk;
        double diffa = ai - ak;
        double diffb = bi - bk;
        double dc = Math.sqrt(diffl * diffl + diffa * diffa + diffb * diffb);
        Point dPt = new Point(Math.min(dx, dy), Math.max(dx, dy));
        Double ds = this.distanceLUT.get(dPt);
        if (ds == null) {
            ds = Math.sqrt(dx * dx + dy * dy);
            this.distanceLUT.put(dPt, ds);
        }
        return Math.sqrt(dc * dc + ds * ds * (this.rigidity * this.rigidity * (double)this.S));
    }

    private double updateClusters(double[][] sequenceData, int[] clusters, double[] ls, double[] as, double[] bs, double[] cxs, double[] cys) {
        double[] newls = new double[this.SPnum];
        double[] newas = new double[this.SPnum];
        double[] newbs = new double[this.SPnum];
        double[] newcxs = new double[this.SPnum];
        double[] newcys = new double[this.SPnum];
        int[] cants = new int[this.SPnum];
        for (int y = 0; y < this.sequence.getHeight(); ++y) {
            int yOff = y * this.sequence.getWidth();
            for (int x = 0; x < this.sequence.getWidth(); ++x) {
                int pos = x + yOff;
                int sp2 = clusters[pos];
                double[] lab = this.getCIELab(sequenceData, pos);
                int n = sp2;
                cants[n] = cants[n] + 1;
                int n2 = sp2;
                newls[n2] = newls[n2] + (lab[0] - newls[sp2]) / (double)cants[sp2];
                int n3 = sp2;
                newas[n3] = newas[n3] + (lab[1] - newas[sp2]) / (double)cants[sp2];
                int n4 = sp2;
                newbs[n4] = newbs[n4] + (lab[2] - newbs[sp2]) / (double)cants[sp2];
                int n5 = sp2;
                newcxs[n5] = newcxs[n5] + ((double)x - newcxs[sp2]) / (double)cants[sp2];
                int n6 = sp2;
                newcys[n6] = newcys[n6] + ((double)y - newcys[sp2]) / (double)cants[sp2];
            }
        }
        double error = IntStream.range(0, this.SPnum).mapToDouble(sp -> {
            double diffx = cxs[sp] - newcxs[sp];
            double diffy = cys[sp] - newcys[sp];
            ls[sp] = newls[sp];
            as[sp] = newas[sp];
            bs[sp] = newbs[sp];
            cxs[sp] = newcxs[sp];
            cys[sp] = newcys[sp];
            return Math.sqrt(diffx * diffx + diffy * diffy);
        }).sum() / (double)this.SPnum;
        return error;
    }

    private void computeSuperpixels(double[][] sequenceData, int[] clusters, double[] ls, double[] as, double[] bs, double[] cxs, double[] cys) {
        boolean[] visited = new boolean[clusters.length];
        int[] finalClusters = new int[clusters.length];
        ArrayList<Point3D.Double> labs = new ArrayList<Point3D.Double>(this.SPnum);
        ArrayList<Double> areas = new ArrayList<Double>(this.SPnum);
        ArrayList<Point> firstPoints = new ArrayList<Point>(this.SPnum);
        AtomicInteger usedLabels = new AtomicInteger(0);
        IntStream.range(0, this.SPnum).forEach(i -> {
            Point3D.Double labCenter = new Point3D.Double();
            AtomicInteger area = new AtomicInteger(0);
            Point p = new Point((int)Math.round(cxs[i]), (int)Math.round(cys[i]));
            int pPos = p.x + p.y * this.sequence.getWidth();
            if (clusters[pPos] == i && !visited[pPos]) {
                this.findAreaAndColor(sequenceData, clusters, finalClusters, visited, p, labCenter, area, usedLabels.getAndIncrement());
                labs.add(labCenter);
                areas.add((double)area.get() / (double)(this.S * this.S));
                firstPoints.add(p);
            }
        });
        int firstUnknownCluster = usedLabels.get();
        for (int y = 0; y < this.sequence.getHeight(); ++y) {
            int yOff = y * this.sequence.getWidth();
            for (int x = 0; x < this.sequence.getWidth(); ++x) {
                int pos = x + yOff;
                if (visited[pos]) continue;
                Point3D.Double labCenter = new Point3D.Double();
                AtomicInteger area = new AtomicInteger(0);
                Point p = new Point(x, y);
                this.findAreaAndColor(sequenceData, clusters, finalClusters, visited, p, labCenter, area, usedLabels.getAndIncrement());
                labs.add(labCenter);
                areas.add((double)area.get() / (double)(this.S * this.S));
                firstPoints.add(p);
            }
        }
        boolean[] mergedClusters = new boolean[usedLabels.get()];
        int[] mergedRefs = IntStream.range(0, usedLabels.get()).toArray();
        IntStream.range(firstUnknownCluster, usedLabels.get()).forEach(i -> {
            List<Integer> neighbors = this.findNeighbors(finalClusters, visited, (Point)firstPoints.get(i));
            if (neighbors.size() > 0) {
                double coeff;
                int bestNeighbour = neighbors.get(0);
                double bestL = Double.MAX_VALUE;
                for (Integer j : neighbors) {
                    double l;
                    if (j >= i || !((l = this.computeL(labs, areas, i, j)) < bestL)) continue;
                    bestNeighbour = j;
                    bestL = l;
                }
                double rArea = (Double)areas.get(i);
                double relSPSize = rArea / 4.0;
                if ((coeff = (relSPSize *= relSPSize) * (1.0 + bestL)) < 0.25) {
                    mergedClusters[i] = true;
                    mergedRefs[i] = bestNeighbour;
                }
            } else {
                System.err.format("Cluster at (%d, %d) has no neighbors", ((Point)firstPoints.get((int)i)).x, ((Point)firstPoints.get((int)i)).y);
            }
        });
        IntStream.range(firstUnknownCluster, usedLabels.get()).forEach(i -> {
            if (mergedClusters[i]) {
                int appliedLabel = i;
                while (appliedLabel != mergedRefs[appliedLabel]) {
                    appliedLabel = mergedRefs[appliedLabel];
                }
                this.findAreaAndColor(sequenceData, clusters, finalClusters, visited, (Point)firstPoints.get(i), new Point3D.Double(), new AtomicInteger(0), appliedLabel);
            }
        });
        if (this.computeROIs) {
            this.rois = new ArrayList<ROI>();
            IntStream.range(0, usedLabels.get()).forEach(i -> {
                if (!mergedClusters[i]) {
                    ROI2DArea roi = this.defineROI(finalClusters, (Point)firstPoints.get(i), (Point3D.Double)labs.get(i));
                    this.rois.add((ROI)roi);
                }
            });
            this.sequence.addROIs(this.rois, false);
        } else {
            List rgbs = labs.stream().map(lab -> CIELab.toRGB(lab.x, lab.y, lab.z)).collect(Collectors.toList());
            this.superPixelsResult = new Sequence(new IcyBufferedImage(this.sequence.getWidth(), this.sequence.getHeight(), 3, DataType.UBYTE));
            this.superPixelsResult.setPixelSizeX(this.sequence.getPixelSizeX());
            this.superPixelsResult.setPixelSizeY(this.sequence.getPixelSizeY());
            this.superPixelsResult.setPixelSizeZ(this.sequence.getPixelSizeZ());
            this.superPixelsResult.setPositionX(this.sequence.getPositionX());
            this.superPixelsResult.setPositionY(this.sequence.getPositionY());
            this.superPixelsResult.setPositionZ(this.sequence.getPositionZ());
            this.superPixelsResult.beginUpdate();
            double[][] spData = Array2DUtil.arrayToDoubleArray((Object)this.superPixelsResult.getDataXYC(0, 0), (boolean)this.superPixelsResult.isSignedDataType());
            for (int y = 0; y < this.sequence.getHeight(); ++y) {
                int yOff = y * this.sequence.getWidth();
                for (int x = 0; x < this.sequence.getWidth(); ++x) {
                    int pos = x + yOff;
                    int[] rgbVal = (int[])rgbs.get(finalClusters[pos]);
                    IntStream.range(0, 3).forEach(c -> {
                        spData[c][pos] = rgbVal[c];
                    });
                }
            }
            Array2DUtil.doubleArrayToArray((double[][])spData, (Object)this.superPixelsResult.getDataXYC(0, 0));
            this.superPixelsResult.dataChanged();
            this.superPixelsResult.endUpdate();
        }
    }

    private void findAreaAndColor(double[][] sequenceData, int[] clusters, int[] newClusters, boolean[] visited, Point p, Point3D.Double labCenter, AtomicInteger area, int label) {
        int posp = p.x + p.y * this.sequence.getWidth();
        area.set(0);
        labCenter.x = 0.0;
        labCenter.y = 0.0;
        labCenter.z = 0.0;
        LinkedList<Point> q = new LinkedList<Point>();
        int val = clusters[posp];
        visited[posp] = true;
        q.add(p);
        while (!q.isEmpty()) {
            Point pti = (Point)q.pop();
            int posi = pti.x + pti.y * this.sequence.getWidth();
            newClusters[posi] = label;
            area.getAndIncrement();
            double[] labi = this.getCIELab(sequenceData, posi);
            labCenter.x += (labi[0] - labCenter.x) / (double)area.get();
            labCenter.y += (labi[1] - labCenter.y) / (double)area.get();
            labCenter.z += (labi[2] - labCenter.z) / (double)area.get();
            int[] ds = new int[]{0, -1, 0, 1, 0};
            for (int is = 1; is < ds.length; ++is) {
                Point ptn = new Point(pti.x + ds[is - 1], pti.y + ds[is]);
                int posn = ptn.x + ptn.y * this.sequence.getWidth();
                if (!this.sequence.getBounds2D().contains(ptn.x, ptn.y) || visited[posn] || clusters[posn] != val) continue;
                visited[posn] = true;
                q.add(ptn);
            }
        }
    }

    private List<Integer> findNeighbors(int[] newClusters, boolean[] visited, Point p) {
        int posp = p.x + p.y * this.sequence.getWidth();
        HashSet<Integer> neighs = new HashSet<Integer>();
        LinkedList<Point> q = new LinkedList<Point>();
        int val = newClusters[posp];
        visited[posp] = false;
        q.add(p);
        while (!q.isEmpty()) {
            Point pti = (Point)q.pop();
            int[] ds = new int[]{0, -1, 0, 1, 0};
            for (int is = 1; is < ds.length; ++is) {
                Point ptn = new Point(pti.x + ds[is - 1], pti.y + ds[is]);
                int posn = ptn.x + ptn.y * this.sequence.getWidth();
                if (!this.sequence.getBounds2D().contains(ptn.x, ptn.y)) continue;
                if (newClusters[posn] == val) {
                    if (!visited[posn]) continue;
                    visited[posn] = false;
                    q.add(ptn);
                    continue;
                }
                neighs.add(newClusters[posn]);
            }
        }
        return new ArrayList<Integer>(neighs);
    }

    private double computeL(List<Point3D.Double> labs, List<Double> areas, int i, Integer j) {
        Point3D.Double diffLab = new Point3D.Double();
        diffLab.x = labs.get((int)j.intValue()).x - labs.get((int)i).x;
        diffLab.y = labs.get((int)j.intValue()).y - labs.get((int)i).y;
        diffLab.z = labs.get((int)j.intValue()).z - labs.get((int)i).z;
        return diffLab.length() / areas.get(j);
    }

    private ROI2DArea defineROI(int[] newClusters, Point p, Point3D.Double labP) {
        int posp = p.x + p.y * this.sequence.getWidth();
        double[] lab = new double[]{labP.x, labP.y, labP.z};
        int[] rgb = CIELab.toRGB(lab);
        int val = newClusters[posp];
        Rectangle seqBounds = this.sequence.getBounds2D();
        ROI2DArea roi1 = new ROI2DArea(new BooleanMask2D());
        IntStream.range(0, newClusters.length).filter(pi -> newClusters[pi] == val).forEach(pi -> roi1.addPoint(pi % seqBounds.width, pi / seqBounds.width));
        roi1.setColor(new Color(rgb[0], rgb[1], rgb[2]));
        return roi1;
    }

    public Sequence getResultSequence() {
        return this.superPixelsResult;
    }
}

