/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.islic;

import algorithms.danyfel80.islic.CIELab;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array2DUtil;
import java.util.stream.IntStream;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarSequence;

public class LABToRGB
extends EzPlug {
    EzVarSequence inLabSequence;

    protected void initialize() {
        this.inLabSequence = new EzVarSequence("LAB sequence");
        this.addEzComponent((EzComponent)this.inLabSequence);
    }

    protected void execute() {
        Sequence labSequence = (Sequence)this.inLabSequence.getValue();
        Sequence rgbSequence = new Sequence(new IcyBufferedImage(labSequence.getWidth(), labSequence.getHeight(), 3, DataType.UBYTE));
        double[][] labIm = Array2DUtil.arrayToDoubleArray((Object)labSequence.getDataXYC(0, 0), (boolean)labSequence.isSignedDataType());
        rgbSequence.beginUpdate();
        double[][] rgbIm = Array2DUtil.arrayToDoubleArray((Object)rgbSequence.getDataXYC(0, 0), (boolean)rgbSequence.isSignedDataType());
        IntStream.range(0, rgbIm[0].length).forEach(pos -> {
            double[] lab = IntStream.range(0, 3).mapToDouble(c -> labIm[c][pos]).toArray();
            int[] rgb = CIELab.toRGB(lab);
            IntStream.range(0, 3).forEach(c -> {
                rgbIm[c][pos] = rgb[c];
            });
        });
        Array2DUtil.doubleArrayToArray((double[][])rgbIm, (Object)rgbSequence.getDataXYC(0, 0));
        rgbSequence.dataChanged();
        rgbSequence.endUpdate();
        this.addSequence(rgbSequence);
    }

    public void clean() {
    }
}

