/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.islic;

import algorithms.danyfel80.islic.CIELab;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array2DUtil;
import java.util.stream.IntStream;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarSequence;

public class RGBToLAB
extends EzPlug {
    EzVarSequence inRgbSequence;

    protected void initialize() {
        this.inRgbSequence = new EzVarSequence("RGB sequence");
        this.addEzComponent((EzComponent)this.inRgbSequence);
    }

    protected void execute() {
        Sequence rgbSequence = (Sequence)this.inRgbSequence.getValue();
        Sequence labSequence = new Sequence(new IcyBufferedImage(rgbSequence.getWidth(), rgbSequence.getHeight(), 3, DataType.DOUBLE));
        double[][] rgbIm = Array2DUtil.arrayToDoubleArray((Object)rgbSequence.getDataXYC(0, 0), (boolean)rgbSequence.isSignedDataType());
        labSequence.beginUpdate();
        double[][] labIm = Array2DUtil.arrayToDoubleArray((Object)labSequence.getDataXYC(0, 0), (boolean)labSequence.isSignedDataType());
        IntStream.range(0, labIm[0].length).forEach(pos -> {
            int[] rgb = IntStream.range(0, 3).map(c -> (int)Math.round(255.0 * (rgbIm[c][pos] / rgbSequence.getDataTypeMax()))).toArray();
            double[] lab = CIELab.fromRGB(rgb);
            IntStream.range(0, 3).forEach(c -> {
                labIm[c][pos] = lab[c];
            });
        });
        Array2DUtil.doubleArrayToArray((double[][])labIm, (Object)labSequence.getDataXYC(0, 0));
        labSequence.dataChanged();
        labSequence.endUpdate();
        labSequence.setName(rgbSequence.getName() + "_LAB");
        this.addSequence(labSequence);
    }

    public void clean() {
    }
}

