/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.islic;

import algorithms.danyfel80.islic.SLICTask;
import icy.gui.dialog.MessageDialog;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.sequence.Sequence;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;

public class SLIC
extends EzPlug
implements Block {
    private EzVarSequence inSequence;
    private EzVarInteger inSPSize;
    private EzVarDouble inSPReg;
    private EzVarBoolean inIsROIOutput;
    private EzVarSequence outSequence;

    protected void initialize() {
        this.inSequence = new EzVarSequence("Sequence");
        this.inSPSize = new EzVarInteger("Superpixel size");
        this.inSPReg = new EzVarDouble("Superpixels regularity");
        this.inIsROIOutput = new EzVarBoolean("Output as ROIs", false);
        this.inSPSize.setValue((Object)30);
        this.inSPReg.setValue((Object)0.2);
        this.addEzComponent((EzComponent)this.inSequence);
        this.addEzComponent((EzComponent)this.inSPSize);
        this.addEzComponent((EzComponent)this.inSPReg);
        this.addEzComponent((EzComponent)this.inIsROIOutput);
    }

    public void declareInput(VarList inputMap) {
        this.inSequence = new EzVarSequence("Sequence");
        this.inSPSize = new EzVarInteger("Superpixel size");
        this.inSPReg = new EzVarDouble("Superpixels regularity");
        this.inIsROIOutput = new EzVarBoolean("Output as ROIs", false);
        this.inSPSize.setValue((Object)30);
        this.inSPReg.setValue((Object)0.2);
        inputMap.add(this.inSequence.name, (Var)this.inSequence.getVariable());
        inputMap.add(this.inSPSize.name, this.inSPSize.getVariable());
        inputMap.add(this.inSPReg.name, this.inSPReg.getVariable());
        inputMap.add(this.inIsROIOutput.name, this.inIsROIOutput.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        this.outSequence = new EzVarSequence("Result");
        outputMap.add(this.outSequence.name, (Var)this.outSequence.getVariable());
    }

    protected void execute() {
        SLICTask task;
        try {
            task = new SLICTask((Sequence)this.inSequence.getValue(), (Integer)this.inSPSize.getValue(), (Double)this.inSPReg.getValue(), (Boolean)this.inIsROIOutput.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!this.isHeadLess()) {
                MessageDialog.showDialog((String)"Initialization Error", (String)String.format("SLIC could not start properly: " + e.getMessage(), new Object[0]), (int)0);
            }
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            task.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!this.isHeadLess()) {
                MessageDialog.showDialog((String)"Runtime Error", (String)String.format("SLIC could not run properly: " + e.getMessage(), new Object[0]), (int)0);
            }
            return;
        }
        long endTime = System.currentTimeMillis();
        long procTime = endTime - startTime;
        System.out.println(String.format("SLIC finished in %d milliseconds", procTime));
        if (!((Boolean)this.inIsROIOutput.getValue()).booleanValue()) {
            task.getResultSequence().setName(((Sequence)this.inSequence.getValue()).getName() + String.format("_SLIC(size=%s,reg=%.2f)", (int)((Integer)this.inSPSize.getValue()), (double)((Double)this.inSPReg.getValue())));
        }
        if (!this.isHeadLess()) {
            MessageDialog.showDialog((String)String.format("SLIC finished in %d milliseconds", procTime));
            this.addSequence(task.getResultSequence());
        } else {
            this.outSequence.setValue(task.getResultSequence());
        }
    }

    public void clean() {
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)SLIC.class.getName()));
    }
}

