/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.op;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.type.collection.CollectionUtil;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.stef.roi.bloc.RoiBlocks;

public class LogicalOperationROI
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected VarROIArray roiSetA = new VarROIArray("ROI(s) group A", null);
    protected VarROIArray roiSetB = new VarROIArray("ROI(s) group B", null);
    protected VarEnum<LogicOperator> op = new VarEnum("Keep", (Enum)LogicOperator.A_CONTAINED_IN_B);
    protected VarBoolean copyRois = new VarBoolean("Copy ROIs", true);
    protected VarROIArray output = new VarROIArray("Result");

    public void run() {
        List<ROI> result = LogicalOperationROI.doLogicalOperation(CollectionUtil.asList((Object[])((Object[])this.roiSetA.getValue())), CollectionUtil.asList((Object[])((Object[])this.roiSetB.getValue())), (LogicOperator)((Object)this.op.getValue()), (Boolean)this.copyRois.getValue());
        this.output.setValue((Object)result.toArray(new ROI[result.size()]));
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("roiA", (Var)this.roiSetA);
        inputMap.add("roiB", (Var)this.roiSetB);
        inputMap.add("op", this.op);
        inputMap.add("generate copies", (Var)this.copyRois);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("out", (Var)this.output);
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }

    public static List<ROI> doLogicalOperation(Collection<ROI> roiSetA, Collection<ROI> roiSetB, LogicOperator logicOp, boolean copyRois) {
        ArrayList<ROI> result = new ArrayList<ROI>();
        HashMap<ROI, SoftReference<BooleanMask2D>> masks2d = new HashMap<ROI, SoftReference<BooleanMask2D>>();
        HashMap<ROI, SoftReference<BooleanMask3D>> masks3d = new HashMap<ROI, SoftReference<BooleanMask3D>>();
        try {
            for (ROI roi : roiSetA) {
                if (roi instanceof ROI2D) {
                    masks2d.put(roi, new SoftReference<BooleanMask2D>(((ROI2D)roi).getBooleanMask(true)));
                    continue;
                }
                if (!(roi instanceof ROI3D)) continue;
                masks3d.put(roi, new SoftReference<BooleanMask3D>(((ROI3D)roi).getBooleanMask(true)));
            }
            for (ROI roi : roiSetB) {
                if (roi instanceof ROI2D) {
                    masks2d.put(roi, new SoftReference<BooleanMask2D>(((ROI2D)roi).getBooleanMask(true)));
                    continue;
                }
                if (!(roi instanceof ROI3D)) continue;
                masks3d.put(roi, new SoftReference<BooleanMask3D>(((ROI3D)roi).getBooleanMask(true)));
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        for (ROI roiA : roiSetA) {
            if (roiA == null) continue;
            BooleanMask2D mask2dA = null;
            BooleanMask3D mask3dA = null;
            SoftReference ref = (SoftReference)masks2d.get(roiA);
            if (ref != null) {
                mask2dA = (BooleanMask2D)ref.get();
            } else {
                ref = (SoftReference)masks3d.get(roiA);
                if (ref != null) {
                    mask3dA = (BooleanMask3D)ref.get();
                }
            }
            boolean cond = logicOp == LogicOperator.A_NOT_CONTAINED_IN_B || logicOp == LogicOperator.A_NOT_CONTAINING_B || logicOp == LogicOperator.A_NOT_INTERSECTING_B;
            boolean done = false;
            for (ROI roiB : roiSetB) {
                BooleanMask2D mask2dB = null;
                BooleanMask3D mask3dB = null;
                ref = (SoftReference)masks2d.get(roiB);
                if (ref != null) {
                    mask2dB = (BooleanMask2D)ref.get();
                } else {
                    ref = (SoftReference)masks3d.get(roiB);
                    if (ref != null) {
                        mask3dB = (BooleanMask3D)ref.get();
                    }
                }
                switch (logicOp) {
                    default: {
                        if (mask2dA != null && mask2dB != null) {
                            if (!mask2dB.contains(mask2dA)) break;
                            done = true;
                            cond = logicOp == LogicOperator.A_CONTAINED_IN_B;
                            break;
                        }
                        if (mask3dA != null && mask3dB != null) {
                            if (!mask3dB.contains(mask3dA)) break;
                            done = true;
                            cond = logicOp == LogicOperator.A_CONTAINED_IN_B;
                            break;
                        }
                        if (!roiB.contains(roiA)) break;
                        done = true;
                        cond = logicOp == LogicOperator.A_CONTAINED_IN_B;
                        break;
                    }
                    case A_CONTAINING_B: 
                    case A_NOT_CONTAINING_B: {
                        if (mask2dA != null && mask2dB != null) {
                            if (!mask2dA.contains(mask2dB)) break;
                            done = true;
                            cond = logicOp == LogicOperator.A_CONTAINING_B;
                            break;
                        }
                        if (mask3dA != null && mask3dB != null) {
                            if (!mask3dA.contains(mask3dB)) break;
                            done = true;
                            cond = logicOp == LogicOperator.A_CONTAINING_B;
                            break;
                        }
                        if (!roiA.contains(roiB)) break;
                        done = true;
                        cond = logicOp == LogicOperator.A_CONTAINING_B;
                        break;
                    }
                    case A_INTERSECTING_B: 
                    case A_NOT_INTERSECTING_B: {
                        if (mask2dA != null && mask2dB != null) {
                            if (!mask2dA.intersects(mask2dB)) break;
                            done = true;
                            cond = logicOp == LogicOperator.A_INTERSECTING_B;
                            break;
                        }
                        if (mask3dA != null && mask3dB != null) {
                            if (!mask3dA.intersects(mask3dB)) break;
                            done = true;
                            cond = logicOp == LogicOperator.A_INTERSECTING_B;
                            break;
                        }
                        if (!roiA.intersects(roiB)) break;
                        done = true;
                        boolean bl = cond = logicOp == LogicOperator.A_INTERSECTING_B;
                    }
                }
                if (!done) continue;
                break;
            }
            if (!cond) continue;
            result.add(copyRois ? roiA.getCopy() : roiA);
        }
        return result;
    }

    public static enum LogicOperator {
        A_CONTAINED_IN_B,
        A_CONTAINING_B,
        A_INTERSECTING_B,
        A_NOT_CONTAINED_IN_B,
        A_NOT_CONTAINING_B,
        A_NOT_INTERSECTING_B;

    }
}

