/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.opencv;

import icy.common.Version;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.math.FPSMeter;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginLibrary;
import icy.sequence.Sequence;
import icy.sequence.SequenceAdapter;
import icy.sequence.SequenceListener;
import icy.system.IcyExceptionHandler;
import icy.system.IcyHandledException;
import icy.system.SystemUtil;
import icy.type.DataType;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;

public class OpenCV
extends Plugin
implements PluginLibrary {
    public static final Version OpenCV_Version = new Version(Core.VERSION_MAJOR, Core.VERSION_MINOR, Core.VERSION_REVISION);
    private static Object buffer = new Object[0];
    private static final ExecutorService service = Executors.newFixedThreadPool(SystemUtil.getNumberOfCPUs());

    public static void initialize() {
    }

    public static IcyBufferedImage convertToIcy(Mat mat) {
        IcyBufferedImage output = new IcyBufferedImage(mat.width(), mat.height(), mat.channels(), OpenCV.getIcyDataType(mat));
        OpenCV.convertToIcy(mat, output);
        return output;
    }

    public static void convertToIcy(Mat mat, final IcyBufferedImage output) {
        int width = mat.cols();
        int height = mat.rows();
        final int nChannels = mat.channels();
        int bufferSize = width * height * nChannels;
        if (nChannels == 1) {
            try {
                Object dataBuffer = output.getDataXY(0);
                Class<?> dataType = dataBuffer.getClass();
                Mat.class.getMethod("get", Integer.TYPE, Integer.TYPE, dataType).invoke((Object)mat, 0, 0, dataBuffer);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (Array.getLength(buffer) != bufferSize) {
            buffer = null;
        }
        final DataType dataType = OpenCV.getIcyDataType(mat);
        Class type = dataType.toPrimitiveClass();
        if (buffer == null || buffer.getClass().getComponentType() != type) {
            buffer = Array.newInstance(type, bufferSize);
        }
        try {
            Mat.class.getMethod("get", Integer.TYPE, Integer.TYPE, buffer.getClass()).invoke((Object)mat, 0, 0, buffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList tasks = new ArrayList(nChannels);
        int c = 0;
        while (c < nChannels) {
            final int n = c++;
            tasks.add(service.submit(new Runnable(){

                @Override
                public void run() {
                    switch (dataType) {
                        case BYTE: 
                        case UBYTE: {
                            byte[] icyChannel = output.getDataXYAsByte(nChannels - n - 1);
                            int out = 0;
                            int in = n;
                            while (out < icyChannel.length) {
                                icyChannel[out] = ((byte[])buffer)[in];
                                ++out;
                                in += nChannels;
                            }
                            break;
                        }
                        case SHORT: 
                        case USHORT: {
                            short[] icyChannel = output.getDataXYAsShort(nChannels - n - 1);
                            int out = 0;
                            int in = n;
                            while (out < icyChannel.length) {
                                icyChannel[out] = ((short[])buffer)[in];
                                ++out;
                                in += nChannels;
                            }
                            break;
                        }
                        case INT: {
                            int[] icyChannel = output.getDataXYAsInt(nChannels - n - 1);
                            int out = 0;
                            int in = n;
                            while (out < icyChannel.length) {
                                icyChannel[out] = ((int[])buffer)[in];
                                ++out;
                                in += nChannels;
                            }
                            break;
                        }
                        case FLOAT: {
                            float[] icyChannel = output.getDataXYAsFloat(nChannels - n - 1);
                            int out = 0;
                            int in = n;
                            while (out < icyChannel.length) {
                                icyChannel[out] = ((float[])buffer)[in];
                                ++out;
                                in += nChannels;
                            }
                            break;
                        }
                        case DOUBLE: {
                            double[] icyChannel = output.getDataXYAsDouble(nChannels - n - 1);
                            int out = 0;
                            int in = n;
                            while (out < icyChannel.length) {
                                icyChannel[out] = ((double[])buffer)[in];
                                ++out;
                                in += nChannels;
                            }
                            break;
                        }
                        default: {
                            Object icyChannel = output.getDataXY(nChannels - n - 1);
                            int size = Array.getLength(icyChannel);
                            int out = 0;
                            int in = n;
                            while (out < size) {
                                System.arraycopy(buffer, in, icyChannel, out, 1);
                                ++out;
                                in += nChannels;
                            }
                            break block0;
                        }
                    }
                }
            }));
        }
        try {
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static Mat convertToOpenCV(IcyBufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int sizeC = img.getSizeC();
        int bufferSize = width * height * sizeC;
        Mat mat = new Mat(new Size(width, height), OpenCV.getCVDataType(img));
        if (sizeC == 1) {
            buffer = img.getDataXY(0);
        } else {
            if (Array.getLength(buffer) != bufferSize) {
                buffer = null;
            }
            Class type = img.getDataType_().toPrimitiveClass();
            if (buffer == null || buffer.getClass().getComponentType() != type) {
                buffer = Array.newInstance(type, bufferSize);
            }
            for (int c = 0; c < sizeC; ++c) {
                Object in = img.getDataXY(sizeC - c - 1);
                int offIN = 0;
                int offOUT = c;
                for (int j = 0; j < height; ++j) {
                    int i = 0;
                    while (i < width) {
                        System.arraycopy(in, offIN, buffer, offOUT, 1);
                        ++i;
                        ++offIN;
                        offOUT += sizeC;
                    }
                }
            }
        }
        try {
            Mat.class.getMethod("put", Integer.TYPE, Integer.TYPE, buffer.getClass()).invoke((Object)mat, 0, 0, buffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mat;
    }

    public static int getCVDataType(IcyBufferedImage img) {
        switch (img.getDataType_()) {
            case BYTE: {
                return CvType.CV_8SC(img.getSizeC());
            }
            case UBYTE: {
                return CvType.CV_8UC(img.getSizeC());
            }
            case SHORT: {
                return CvType.CV_16SC(img.getSizeC());
            }
            case USHORT: {
                return CvType.CV_16UC(img.getSizeC());
            }
            case INT: 
            case UINT: {
                return CvType.CV_32SC(img.getSizeC());
            }
            case FLOAT: {
                return CvType.CV_32FC(img.getSizeC());
            }
            case DOUBLE: {
                return CvType.CV_64FC(img.getSizeC());
            }
        }
        throw new UnsupportedOperationException("OpenCV does not support type " + img.getDataType_());
    }

    public static DataType getIcyDataType(Mat mat) {
        switch (CvType.depth(mat.type())) {
            case 1: {
                return DataType.BYTE;
            }
            case 0: {
                return DataType.UBYTE;
            }
            case 3: {
                return DataType.SHORT;
            }
            case 2: {
                return DataType.USHORT;
            }
            case 4: {
                return DataType.INT;
            }
            case 5: {
                return DataType.FLOAT;
            }
            case 6: {
                return DataType.DOUBLE;
            }
        }
        return null;
    }

    public static void liveWebcam() {
        OpenCV.liveWebcam(-1, -1, -1);
    }

    public static void liveWebcam(int width, int height, int fps) {
        VideoCapture vc = new VideoCapture(0);
        if (width != -1) {
            vc.set(3, width);
        }
        if (height != -1) {
            vc.set(4, height);
        }
        if (fps != -1) {
            vc.set(5, fps);
        }
        OpenCV.liveWebcam(vc);
    }

    public static void liveWebcam(final VideoCapture camera) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final Thread currentThread = Thread.currentThread();
                Mat mat = new Mat();
                camera.read(mat);
                IcyBufferedImage image = OpenCV.convertToIcy(mat);
                final Sequence s = new Sequence("Live webcam", image);
                Icy.getMainInterface().addSequence(s);
                image.setAutoUpdateChannelBounds(false);
                s.setAutoUpdateChannelBounds(false);
                s.addListener((SequenceListener)new SequenceAdapter(){

                    public void sequenceClosed(Sequence sequence) {
                        s.removeListener((SequenceListener)this);
                        currentThread.interrupt();
                    }
                });
                try {
                    FPSMeter fps = new FPSMeter();
                    long grabTime = 0L;
                    long readTime = 0L;
                    long conversionTime = 0L;
                    long dataUpdateTime = 0L;
                    double nbIterations = 0.0;
                    while (!currentThread.isInterrupted()) {
                        long t0 = System.nanoTime();
                        camera.grab();
                        long t1 = System.nanoTime();
                        camera.retrieve(mat);
                        long t2 = System.nanoTime();
                        OpenCV.convertToIcy(mat, image);
                        long t3 = System.nanoTime();
                        image.dataChanged();
                        long t4 = System.nanoTime();
                        fps.update();
                        nbIterations += 1.0;
                        grabTime += (t1 - t0) / 1000000L;
                        readTime += (t2 - t1) / 1000000L;
                        conversionTime += (t3 - t2) / 1000000L;
                        dataUpdateTime += (t4 - t3) / 1000000L;
                    }
                    System.out.println("Capture frame-rate: " + fps.getFPS() + " fps");
                    System.out.println("Camera grab time: " + (double)grabTime / nbIterations + " ms");
                    System.out.println("Camera read time: " + (double)readTime / nbIterations + " ms");
                    System.out.println("Conversion time: " + (double)conversionTime / nbIterations + " ms");
                    System.out.println("Data update time: " + (double)dataUpdateTime / nbIterations + " ms");
                }
                finally {
                    camera.release();
                }
            }
        }).start();
    }

    public static void testSobel() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Sequence s = Icy.getMainInterface().getActiveSequence();
                if (s == null) {
                    throw new IcyHandledException("Open an image first!");
                }
                Mat mat = OpenCV.convertToOpenCV(Icy.getMainInterface().getActiveImage());
                Mat x = new Mat();
                Mat y = new Mat();
                Imgproc.Sobel(mat, x, -1, 1, 0);
                Imgproc.Sobel(mat, y, -1, 0, 1);
                Core.addWeighted(x, 0.5, y, 0.5, 1.0, mat);
                s = new Sequence("OpenCV: Sobel filter applied to " + s.getName(), OpenCV.convertToIcy(mat));
                Icy.getMainInterface().addSequence(s);
            }
        }).start();
    }

    public static BufferedImage rpi_raspistillToBufferedImage(int width, int height) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("raspistill");
        command.add("-o");
        command.add("-v");
        command.add("-w");
        command.add("" + width);
        command.add("-h");
        command.add("" + height);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        BufferedImage bi = ImageIO.read(p.getInputStream());
        return bi;
    }

    static {
        String loadingMessage = "Loading OpenCV " + OpenCV_Version + "...";
        String successMessage = "OpenCV " + OpenCV_Version + " successfully loaded.";
        try {
            System.out.println(loadingMessage);
            nu.pattern.OpenCV.loadShared();
            System.out.println(successMessage);
        }
        catch (UnsatisfiedLinkError lib1) {
            IcyExceptionHandler.handleException((Throwable)lib1, (boolean)true);
            System.out.println("Trying alternate method");
            try {
                OpenCV.loadLibrary(OpenCV.class, (String)Core.NATIVE_LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError lib2) {
                IcyExceptionHandler.handleException((Throwable)lib2, (boolean)true);
                System.out.println("Last chance...");
                try {
                    System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
                }
                catch (UnsatisfiedLinkError lib3) {
                    IcyExceptionHandler.handleException((Throwable)lib3, (boolean)true);
                }
            }
        }
    }
}

