/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.opencv;

import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.math.FPSMeter;
import icy.sequence.Sequence;
import icy.sequence.SequenceAdapter;
import icy.sequence.SequenceListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSeparator;
import org.opencv.core.Mat;
import org.opencv.videoio.VideoCapture;
import org.opencv.videoio.Videoio;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.opencv.OpenCV;
import plugins.adufour.vars.util.VarException;

public class OpenCVCapture
extends EzPlug
implements EzStoppable,
EzVarListener<Integer> {
    List<EzVarInteger> parameters = new ArrayList<EzVarInteger>();
    VideoCapture camera = null;

    protected void initialize() {
        OpenCV.initialize();
        for (Field f : Videoio.class.getDeclaredFields()) {
            String name = f.getName();
            if (!name.startsWith("CAP_PROP_") || name.contains("_DC1394") || name.contains("_GIGA") || name.contains("_GPHOTO2") || name.contains("_GSTREAMER") || name.contains("_INTELPERC") || name.contains("_IOS") || name.contains("_OPENNI") || name.contains("_POS") || name.contains("_PVAPI") || name.contains("_XI")) continue;
            name = name.substring(9).toLowerCase();
            EzVarInteger setting = new EzVarInteger(name);
            setting.setValue((Object)-1);
            setting.addVarChangeListener((EzVarListener)this);
            this.parameters.add(setting);
        }
        int cpt = 0;
        for (EzVarInteger setting : this.parameters) {
            this.addEzComponent((EzComponent)setting);
            if (++cpt % 20 != 0) continue;
            this.addComponent(new JSeparator(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        this.camera = new VideoCapture(0);
        for (EzVarInteger setting : this.parameters) {
            if ((Integer)setting.getValue() == -1) continue;
            String propName = "CAP_PROP_" + setting.name.toUpperCase();
            try {
                int propID = Videoio.class.getDeclaredField(propName).getInt(null);
                this.camera.set(propID, ((Integer)setting.getValue()).intValue());
            }
            catch (Exception e) {
                throw new VarException(setting.getVariable(), e.getMessage());
            }
        }
        Mat mat = new Mat();
        this.camera.read(mat);
        IcyBufferedImage image = OpenCV.convertToIcy(mat);
        final Sequence s = new Sequence("Live webcam", image);
        Icy.getMainInterface().addSequence(s);
        image.setAutoUpdateChannelBounds(false);
        s.setAutoUpdateChannelBounds(false);
        final Thread thread = Thread.currentThread();
        s.addListener((SequenceListener)new SequenceAdapter(){

            public void sequenceClosed(Sequence sequence) {
                s.removeListener((SequenceListener)this);
                thread.interrupt();
            }
        });
        FPSMeter fps = new FPSMeter();
        try {
            while (this.camera.read(mat) && !Thread.currentThread().isInterrupted()) {
                OpenCV.convertToIcy(mat, image);
                image.dataChanged();
                fps.update();
                this.getUI().setProgressBarMessage("Acquiring at " + fps.getFPS() + "fps");
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.camera.release();
        }
    }

    public void clean() {
        for (EzVarInteger setting : this.parameters) {
            setting.removeVarChangeListener((EzVarListener)this);
        }
        this.parameters.clear();
    }

    public void variableChanged(EzVar<Integer> source, Integer newValue) {
        if (this.camera == null) {
            return;
        }
        String propName = "CAP_PROP_" + source.name.toUpperCase();
        try {
            int propID = Videoio.class.getDeclaredField(propName).getInt(null);
            this.camera.set(propID, newValue.intValue());
        }
        catch (Exception e) {
            throw new VarException(source.getVariable(), e.getMessage());
        }
    }
}

