/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaCL {
    static final boolean verbose = "true".equals(System.getProperty("javacl.verbose")) || "1".equals(System.getenv("JAVACL_VERBOSE"));
    static final int minLogLevel = Level.WARNING.intValue();
    static final OpenCLLibrary CL;

    static boolean shouldLog(Level level) {
        return verbose || level.intValue() >= minLogLevel;
    }

    static boolean log(Level level, String message, Throwable ex) {
        if (!JavaCL.shouldLog(level)) {
            return true;
        }
        Logger.getLogger(JavaCL.class.getName()).log(level, message, ex);
        return true;
    }

    static boolean log(Level level, String message) {
        JavaCL.log(level, message, null);
        return true;
    }

    private static int getPlatformIDs(OpenCLLibrary lib, int count, OpenCLLibrary.cl_platform_id[] out, IntByReference pCount) {
        try {
            return lib.clIcdGetPlatformIDsKHR(count, out, pCount);
        }
        catch (Throwable th) {
            return lib.clGetPlatformIDs(count, out, pCount);
        }
    }

    public static CLPlatform[] listGPUPoweredPlatforms() {
        CLPlatform[] platforms = JavaCL.listPlatforms();
        ArrayList<CLPlatform> out = new ArrayList<CLPlatform>(platforms.length);
        for (CLPlatform platform : platforms) {
            if (platform.listGPUDevices(true).length <= 0) continue;
            out.add(platform);
        }
        return out.toArray(new CLPlatform[out.size()]);
    }

    public static CLPlatform[] listPlatforms() {
        IntByReference pCount = new IntByReference();
        CLException.error(JavaCL.getPlatformIDs(CL, 0, null, pCount));
        int nPlats = pCount.getValue();
        if (nPlats == 0) {
            return new CLPlatform[0];
        }
        OpenCLLibrary.cl_platform_id[] ids = new OpenCLLibrary.cl_platform_id[nPlats];
        CLException.error(JavaCL.getPlatformIDs(CL, nPlats, ids, null));
        CLPlatform[] platforms = new CLPlatform[nPlats];
        for (int i = 0; i < nPlats; ++i) {
            platforms[i] = new CLPlatform(ids[i]);
        }
        return platforms;
    }

    public static CLContext createContext(Map<CLPlatform.ContextProperties, Object> contextProperties, CLDevice ... devices) {
        return devices[0].getPlatform().createContext(contextProperties, devices);
    }

    public static void unloadCompiler() {
        CLException.error(CL.clUnloadCompiler());
    }

    public static CLDevice getBestDevice() {
        return JavaCL.getBestDevice(CLPlatform.DeviceFeature.MaxComputeUnits);
    }

    public static CLDevice getBestDevice(CLPlatform.DeviceFeature ... preferredFeatures) {
        ArrayList<CLDevice> devices = new ArrayList<CLDevice>();
        for (CLPlatform platform : JavaCL.listPlatforms()) {
            devices.addAll(Arrays.asList(platform.listAllDevices(true)));
        }
        return CLPlatform.getBestDevice(Arrays.asList(preferredFeatures), devices);
    }

    public static CLContext createBestContext() {
        return JavaCL.createBestContext(CLPlatform.DeviceFeature.MaxComputeUnits);
    }

    public static CLContext createBestContext(CLPlatform.DeviceFeature ... preferredFeatures) {
        CLDevice device = JavaCL.getBestDevice(preferredFeatures);
        return device.getPlatform().createContext(null, device);
    }

    public static CLContext createContextFromCurrentGL() {
        RuntimeException first = null;
        for (CLPlatform platform : JavaCL.listPlatforms()) {
            try {
                CLContext ctx = platform.createContextFromCurrentGL();
                if (ctx == null) continue;
                return ctx;
            }
            catch (RuntimeException ex) {
                if (first != null) continue;
                first = ex;
            }
        }
        throw new RuntimeException("Failed to create an OpenCL context based on the current OpenGL context", first);
    }

    static {
        Class libClass = Platform.isWindows() && !Platform.is64Bit() ? OpenCLStdCallLibrary.class : OpenCLLibrary.class;
        OpenCLLibrary lib = (OpenCLLibrary)Native.loadLibrary("OpenCL", libClass);
        try {
            IntByReference pCount = new IntByReference();
            boolean success = false;
            try {
                success = JavaCL.getPlatformIDs(lib, 0, null, pCount) == 0;
            }
            catch (Throwable th) {
                // empty catch block
            }
            if (!success) {
                int err;
                OpenCLLibrary atiLib = null;
                if (Platform.is64Bit()) {
                    atiLib = (OpenCLLibrary)Native.loadLibrary("atiocl64", libClass);
                }
                if (atiLib == null) {
                    atiLib = (OpenCLLibrary)Native.loadLibrary("atiocl32", libClass);
                }
                if (atiLib == null) {
                    atiLib = (OpenCLLibrary)Native.loadLibrary("atiocl", libClass);
                }
                if (atiLib != null && (err = JavaCL.getPlatformIDs(atiLib, 0, null, pCount)) == 0) {
                    System.out.println("[JavaCL] Hacking around ATI's weird driver bugs (using atiocl library instead of OpenCL)");
                    lib = atiLib;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CL = (OpenCLLibrary)Native.synchronizedLibrary(lib);
    }

    public static interface OpenCLStdCallLibrary
    extends OpenCLLibrary,
    StdCallLibrary {
    }
}

